/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.util.plugins;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.jetbrains.annotations.NotNull;
import org.pepsoft.util.FileUtils;
import org.pepsoft.util.ObjectMapperHolder;
import org.pepsoft.util.StreamUtils;
import org.pepsoft.util.Version;
import org.pepsoft.util.mdc.MDCCapturingRuntimeException;
import org.pepsoft.util.plugins.Descriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PluginManager {
    private static final Map<JarFile, ClassLoader> jarClassLoaders = new HashMap<JarFile, ClassLoader>();
    private static final int BUFFER_SIZE = 32768;
    private static final int UPDATE_TIMEOUT = 200;
    private static final int MAXIMUM_PLUGIN_UPDATE_SIZE = 0x200000;
    private static final ClassLoader classLoader = new ClassLoader(ClassLoader.getSystemClassLoader()){

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            for (Map.Entry entry : jarClassLoaders.entrySet()) {
                Class<?> _class;
                try {
                    _class = ((ClassLoader)entry.getValue()).loadClass(name);
                }
                catch (ClassNotFoundException e) {
                    continue;
                }
                logger.debug("Loading {} from {}", (Object)name, (Object)((JarFile)entry.getKey()).getName());
                return _class;
            }
            throw new ClassNotFoundException("Class " + name + " not found in plugin class loaders");
        }
    };
    private static final List<String> errors = new ArrayList<String>();
    private static final List<String> messages = new ArrayList<String>();
    private static final Logger logger = LoggerFactory.getLogger(PluginManager.class);

    private PluginManager() {
    }

    public static void loadPlugins(File pluginDir, PublicKey publicKey, String descriptorPath, Version hostVersion, boolean updatePlugins) {
        File[] pluginFiles;
        if (logger.isDebugEnabled()) {
            logger.debug("Loading plugins");
        }
        if ((pluginFiles = pluginDir.listFiles((dir, name) -> name.toLowerCase().endsWith(".jar"))) != null) {
            for (File pluginFile : pluginFiles) {
                try {
                    JarFile jarFile = new JarFile(pluginFile);
                    if (!PluginManager.isSigned(jarFile, publicKey)) {
                        String message = FileUtils.stripDirectory(jarFile.getName()) + " is not official or has been tampered with";
                        errors.add(message);
                        logger.error(message + "; not loading it");
                        continue;
                    }
                    if (updatePlugins) {
                        PluginManager.checkForUpdates(jarFile, publicKey, descriptorPath, hostVersion);
                    }
                    Descriptor descriptor = PluginManager.loadDescriptor(jarFile, descriptorPath);
                    if (descriptor.minimumHostVersion != null && !hostVersion.isAtLeast(descriptor.minimumHostVersion)) {
                        String message = "Plugin " + descriptor.name + " requires at least version " + descriptor.minimumHostVersion + " of the host";
                        errors.add(message);
                        logger.error(message + "; not loading it");
                        continue;
                    }
                    URLClassLoader pluginClassLoader = new URLClassLoader(new URL[]{pluginFile.toURI().toURL()});
                    jarClassLoaders.put(jarFile, pluginClassLoader);
                }
                catch (IOException e) {
                    errors.add(pluginFile.getName() + " could not be loaded due to an I/O error");
                    logger.error("{} while loading plugin from file {} (message: {}); not loading it", new Object[]{e.getClass().getSimpleName(), pluginFile.getName(), e.getMessage(), e});
                }
            }
        }
    }

    public static <T> List<T> findPlugins(Class<T> type, String descriptorPath, ClassLoader classLoader) {
        try {
            ArrayList plugins = new ArrayList();
            PluginManager.findPlugins(type, descriptorPath, classLoader, plugins);
            for (JarFile pluginJar : jarClassLoaders.keySet()) {
                try {
                    PluginManager.findPlugins(type, descriptorPath, pluginJar, plugins);
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoClassDefFoundError e) {
                    errors.add(FileUtils.stripDirectory(pluginJar.getName()) + " could not be loaded; perhaps it is not compatible with this version of the host");
                    logger.error("{} while instantiating plugin {} (message: {}); skipping plugin", new Object[]{e.getClass().getSimpleName(), pluginJar.getName(), e.getMessage(), e});
                }
            }
            return plugins;
        }
        catch (IOException e) {
            throw new MDCCapturingRuntimeException("I/O error while loading plugins", e);
        }
    }

    public static ClassLoader getPluginClassLoader() {
        return classLoader;
    }

    @NotNull
    public static List<String> getMessages() {
        return Collections.unmodifiableList(messages);
    }

    @NotNull
    public static List<String> getErrors() {
        return Collections.unmodifiableList(errors);
    }

    private static boolean isSigned(JarFile jarFile, PublicKey publicKey) throws IOException {
        Enumeration<JarEntry> e = jarFile.entries();
        while (e.hasMoreElements()) {
            JarEntry jarEntry = e.nextElement();
            String entryName = jarEntry.getName().toUpperCase();
            if (jarEntry.isDirectory() || entryName.endsWith(".SF") || entryName.endsWith(".DSA") || entryName.endsWith(".EC") || entryName.endsWith(".RSA")) continue;
            byte[] buffer = new byte[32768];
            try (InputStream in = jarFile.getInputStream(jarEntry);){
                while (in.read(buffer) != -1) {
                }
            }
            Certificate[] certificates = jarEntry.getCertificates();
            boolean signed = false;
            if (certificates != null) {
                for (Certificate certificate : certificates) {
                    if (!certificate.getPublicKey().equals(publicKey)) continue;
                    signed = true;
                    break;
                }
            }
            if (signed) continue;
            return false;
        }
        return true;
    }

    private static <T> void findPlugins(Class<T> type, String descriptorPath, JarFile jarFile, List<T> plugins) throws IOException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        Descriptor descriptor = PluginManager.loadDescriptor(jarFile, descriptorPath);
        for (String class_ : descriptor.classes) {
            Class<?> pluginType = classLoader.loadClass(class_);
            if (!type.isAssignableFrom(pluginType)) continue;
            plugins.add(pluginType.newInstance());
        }
    }

    private static <T> void findPlugins(Class<T> type, String descriptorPath, ClassLoader classLoader, List<T> plugins) throws IOException {
        Enumeration<URL> resources = classLoader.getResources(descriptorPath);
        while (resources.hasMoreElements()) {
            try {
                InputStream in = resources.nextElement().openStream();
                try {
                    Descriptor descriptor = PluginManager.loadDescriptor(in, null);
                    for (String class_ : descriptor.classes) {
                        Class<?> pluginType = classLoader.loadClass(class_);
                        if (!type.isAssignableFrom(pluginType)) continue;
                        plugins.add(pluginType.newInstance());
                    }
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
            catch (IOException | ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                errors.add("Could not load or initialise plugin from class path; internal error");
                logger.error("{} while instantiating plugin (message: {}); skipping plugin", new Object[]{e.getClass().getSimpleName(), e.getMessage(), e});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkForUpdates(JarFile jarFile, PublicKey publicKey, String descriptorPath, Version hostVersion) {
        File originalFile = new File(jarFile.getName());
        try {
            Descriptor descriptor = PluginManager.loadDescriptor(jarFile, descriptorPath);
            if (descriptor.version == null) {
                logger.warn("Local descriptor for plugin {} does not provide enough information to check for updates (missing version)", (Object)descriptor.name);
                return;
            }
            if (descriptor.descriptorUrl == null) {
                logger.warn("Local descriptor for plugin {} does not provide enough information to check for updates (missing descriptorUrl)", (Object)descriptor.name);
                return;
            }
            URL descriptorUrl = new URL(descriptor.descriptorUrl);
            HttpURLConnection connection = (HttpURLConnection)descriptorUrl.openConnection();
            connection.setAllowUserInteraction(false);
            connection.setUseCaches(false);
            connection.setConnectTimeout(200);
            connection.setReadTimeout(200);
            connection.connect();
            if (connection.getResponseCode() != 200) {
                throw new IOException("Server responded with status code " + connection.getResponseCode() + " (message: \"" + connection.getResponseMessage() + "\") after requesting " + descriptor.descriptorUrl);
            }
            Descriptor newDescriptor = PluginManager.loadDescriptor(connection.getInputStream(), descriptor.name);
            if (newDescriptor.version == null) {
                logger.warn("Remote descriptor for plugin {} does not provide enough information to check for updates (missing version)", (Object)descriptor.name);
                return;
            }
            if (newDescriptor.pluginUrl == null) {
                logger.warn("Remote descriptor for plugin {} does not provide enough information to check for updates (missing pluginUrl)", (Object)descriptor.name);
                return;
            }
            if (newDescriptor.version.compareTo(descriptor.version) <= 0) {
                logger.debug("Plugin {} not updated (our version: {}, remote version: {})", new Object[]{descriptor.name, descriptor.version, newDescriptor.version});
                return;
            }
            if (newDescriptor.minimumHostVersion != null && newDescriptor.minimumHostVersion.compareTo(hostVersion) > 0) {
                logger.info("Plugin {} not updated because it requires a newer host version ({})", (Object)descriptor.name, (Object)descriptor.minimumHostVersion);
                return;
            }
            logger.info("Update found for plugin {}; downloading version {}", (Object)descriptor.name, (Object)newDescriptor.version);
            URL pluginUrl = new URL(descriptorUrl, newDescriptor.pluginUrl);
            connection = (HttpURLConnection)pluginUrl.openConnection();
            connection.setAllowUserInteraction(false);
            connection.setUseCaches(false);
            connection.setConnectTimeout(200);
            connection.setReadTimeout(200);
            connection.connect();
            if (connection.getResponseCode() != 200) {
                throw new IOException("Server responded with status code " + connection.getResponseCode() + " (message: \"" + connection.getResponseMessage() + "\") after requesting " + newDescriptor.pluginUrl);
            }
            File tempFile = File.createTempFile("wpdownloadedplugin", null);
            try {
                try (InputStream in2 = connection.getInputStream();
                     FileOutputStream out = new FileOutputStream(tempFile);){
                    StreamUtils.copy(in2, out, 0x200000);
                }
                if (!PluginManager.isSigned(new JarFile(tempFile), publicKey)) {
                    logger.error("Update for {} downloaded, but is not official or has been tampered with; not updating plugin", (Object)descriptor.name);
                    return;
                }
                Files.move(originalFile.toPath(), new File(originalFile.getParentFile(), originalFile.getName() + ".bak").toPath(), StandardCopyOption.REPLACE_EXISTING);
                Files.move(tempFile.toPath(), originalFile.toPath(), new CopyOption[0]);
                messages.add("Plugin " + descriptor.name + " was updated from version " + descriptor.version + " to version " + newDescriptor.version);
            }
            finally {
                tempFile.delete();
            }
        }
        catch (IOException | ClassCastException e) {
            logger.error("{} while checking for updates for plugin {} (message: {})", new Object[]{e.getClass().getSimpleName(), originalFile, e.getMessage(), e});
        }
    }

    private static Descriptor loadDescriptor(JarFile jarFile, String descriptorPath) throws IOException {
        try (InputStream in = jarFile.getInputStream(new ZipEntry(descriptorPath));){
            Descriptor descriptor = PluginManager.loadDescriptor(in, FileUtils.stripExtension(FileUtils.stripDirectory(jarFile.getName())));
            return descriptor;
        }
    }

    public static Descriptor loadDescriptor(InputStream in, String name) throws IOException {
        try (BufferedInputStream in2 = new BufferedInputStream(in);){
            in2.mark(1);
            boolean json = in2.read() == 123;
            in2.reset();
            if (!json && logger.isDebugEnabled()) {
                logger.debug("Plugin descriptor does not start with {; assuming it is not JSON");
            }
            if (json) {
                Map descriptor = (Map)ObjectMapperHolder.OBJECT_MAPPER.readValue((InputStream)in2, Map.class);
                String myName = (String)descriptor.get("name");
                Version version = Version.parse((String)descriptor.get("version"));
                String minimumHostVersionStr = (String)descriptor.get("minimumHostVersion");
                List classes = (List)descriptor.get("classes");
                String descriptorUrl = (String)descriptor.get("descriptorUrl");
                String pluginUrl = (String)descriptor.get("pluginUrl");
                Descriptor descriptor2 = new Descriptor(myName != null ? myName : name, classes, descriptorUrl, pluginUrl, version, minimumHostVersionStr != null ? Version.parse(minimumHostVersionStr) : null);
                return descriptor2;
            }
            ArrayList<String> classes = new ArrayList<String>();
            try (BufferedReader lineReader = new BufferedReader(new InputStreamReader((InputStream)in2, StandardCharsets.UTF_8));){
                String line;
                while ((line = lineReader.readLine()) != null) {
                    classes.add(line.trim());
                }
            }
            Descriptor descriptor = new Descriptor(name, classes, null, null, null, null);
            return descriptor;
        }
    }
}

