/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.util;

import java.util.AbstractList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class DynamicList<T>
extends AbstractList<T> {
    private final int bucketSize;
    private final Map<Integer, Object[]> buckets = new HashMap<Integer, Object[]>();
    private int size;
    public static final int DEFAULT_BUCKET_SIZE = 16;

    public DynamicList() {
        this(16);
    }

    public DynamicList(int bucketSize) {
        this.bucketSize = bucketSize;
    }

    public DynamicList(Collection<T> collection) {
        this(collection, 16);
    }

    public DynamicList(Collection<T> collection, int bucketSize) {
        this.bucketSize = bucketSize;
        this.addAll(collection);
    }

    @Override
    public T get(int index) {
        int bucketIndex = index / this.bucketSize;
        Object[] bucket = this.buckets.get(bucketIndex);
        return (T)(bucket != null ? bucket[index - bucketIndex * this.bucketSize] : null);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public T set(int index, T element) {
        Object previousElement;
        int bucketIndex;
        Object[] bucket;
        if (index >= this.size) {
            this.size = index + 1;
        }
        if ((bucket = this.buckets.get(bucketIndex = index / this.bucketSize)) == null) {
            previousElement = null;
            if (element != null) {
                bucket = new Object[this.bucketSize];
                bucket[index - bucketIndex * this.bucketSize] = element;
                this.buckets.put(bucketIndex, bucket);
            }
        } else {
            previousElement = bucket[index - bucketIndex * this.bucketSize];
            bucket[index - bucketIndex * this.bucketSize] = element;
        }
        return (T)previousElement;
    }
}

