/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.util;

import java.util.BitSet;
import org.pepsoft.util.ExceptionUtils;
import org.pepsoft.util.ProgressReceiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParallelProgressManager {
    private final ProgressReceiver progressReceiver;
    private final boolean taskCountKnown;
    private final BitSet running = new BitSet();
    private int taskCount;
    private int tasksCreated;
    private float[] taskProgress;
    private Throwable previousException;
    private boolean started;
    private boolean exceptionThrown;
    private boolean exceptionReported;
    private static final Logger logger = LoggerFactory.getLogger(ParallelProgressManager.class);

    public ParallelProgressManager(ProgressReceiver progressReceiver) {
        this.progressReceiver = progressReceiver;
        this.taskCountKnown = false;
    }

    public ParallelProgressManager(ProgressReceiver progressReceiver, int taskCount) {
        this.progressReceiver = progressReceiver;
        this.taskCount = taskCount;
        this.taskCountKnown = true;
        this.taskProgress = new float[taskCount];
        this.running.set(0, taskCount);
        this.started = true;
    }

    public synchronized ProgressReceiver createProgressReceiver() {
        if (!this.taskCountKnown && this.started) {
            throw new IllegalStateException("Cannot create new progress receivers after tasks have started");
        }
        if (this.taskCountKnown && this.tasksCreated == this.taskCount) {
            throw new IllegalStateException("Attempt to create more sub progress receivers than indicated task count (" + this.taskCount + ")");
        }
        return new SubProgressReceiver(this.tasksCreated++);
    }

    public synchronized void join() throws InterruptedException {
        while (true) {
            if (!this.started) {
                this.wait();
                continue;
            }
            if (this.running.isEmpty()) {
                return;
            }
            this.wait();
        }
    }

    public synchronized boolean isExceptionThrown() {
        return this.exceptionThrown;
    }

    private synchronized void setProgress(int index, float subProgress) throws ProgressReceiver.OperationCancelled {
        if (!this.started) {
            this.start();
        }
        this.cancelIfPreviousException();
        this.taskProgress[index] = subProgress;
        float totalProgress = 0.0f;
        for (float progress : this.taskProgress) {
            totalProgress += progress;
        }
        try {
            this.progressReceiver.setProgress(totalProgress / (float)this.taskCount);
        }
        catch (ProgressReceiver.OperationCancelled e) {
            this.previousException = e;
            throw e;
        }
    }

    private synchronized void exceptionThrown(int index, Throwable exception) {
        if (!this.started) {
            this.start();
        }
        this.exceptionThrown = true;
        if (this.previousException == null) {
            this.previousException = exception;
        }
        this.running.clear(index);
        this.notifyAll();
        if (!this.exceptionReported) {
            this.exceptionReported = true;
            this.progressReceiver.exceptionThrown(exception);
        } else if (ExceptionUtils.chainContains(exception, ProgressReceiver.OperationCancelledByUser.class)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Operation cancelled by user; not reporting to progress receiver");
            }
        } else if (ExceptionUtils.chainContains(exception, ProgressReceiver.OperationCancelled.class)) {
            logger.debug("Operation cancelled on thread {} (message: \"{}\")", (Object)Thread.currentThread().getName(), (Object)exception.getMessage());
        } else {
            logger.error("Secondary exception from parallel task; not reporting to progress receiver", exception);
        }
    }

    private synchronized void done(int index) {
        if (!this.started) {
            this.start();
        }
        this.running.clear(index);
        this.notifyAll();
        if (!this.exceptionReported && this.running.isEmpty()) {
            this.progressReceiver.done();
        }
    }

    private synchronized void setMessage(int index, String message) throws ProgressReceiver.OperationCancelled {
        if (!this.started) {
            this.start();
        }
        this.cancelIfPreviousException();
        this.progressReceiver.setMessage(message);
    }

    private synchronized void checkForCancellation() throws ProgressReceiver.OperationCancelled {
        if (!this.started) {
            this.start();
        }
        this.cancelIfPreviousException();
    }

    private synchronized void subProgressStarted(org.pepsoft.util.SubProgressReceiver subProgressReceiver) throws ProgressReceiver.OperationCancelled {
        if (!this.started) {
            this.start();
        }
        this.cancelIfPreviousException();
        this.progressReceiver.subProgressStarted(subProgressReceiver);
    }

    private synchronized void start() {
        this.taskCount = this.tasksCreated;
        this.taskProgress = new float[this.taskCount];
        this.running.set(0, this.taskCount);
        this.started = true;
        this.notifyAll();
    }

    private void cancelIfPreviousException() throws ProgressReceiver.OperationCancelled {
        if (this.previousException != null) {
            throw new ProgressReceiver.OperationCancelled("Operation cancelled due to exception on other thread (type: " + this.previousException.getClass().getSimpleName() + ", message: " + this.previousException.getMessage() + ")", this.previousException);
        }
    }

    private class SubProgressReceiver
    implements ProgressReceiver {
        private final int index;

        private SubProgressReceiver(int index) {
            this.index = index;
        }

        @Override
        public void setProgress(float progress) throws ProgressReceiver.OperationCancelled {
            ParallelProgressManager.this.setProgress(this.index, progress);
        }

        @Override
        public void exceptionThrown(Throwable exception) {
            ParallelProgressManager.this.exceptionThrown(this.index, exception);
        }

        @Override
        public void done() {
            ParallelProgressManager.this.done(this.index);
        }

        @Override
        public void setMessage(String message) throws ProgressReceiver.OperationCancelled {
            ParallelProgressManager.this.setMessage(this.index, message);
        }

        @Override
        public void checkForCancellation() throws ProgressReceiver.OperationCancelled {
            ParallelProgressManager.this.checkForCancellation();
        }

        @Override
        public void reset() {
            throw new UnsupportedOperationException("Not supported");
        }

        @Override
        public void subProgressStarted(org.pepsoft.util.SubProgressReceiver subProgressReceiver) throws ProgressReceiver.OperationCancelled {
            ParallelProgressManager.this.subProgressStarted(subProgressReceiver);
        }
    }
}

