/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.util;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.pepsoft.util.ProgressReceiver;

public class SubProgressReceiver
implements ProgressReceiver {
    private final ProgressReceiver progressReceiver;
    private final float offset;
    private final float extent;
    private final Throwable creationTrace;
    private List<ProgressReceiver> listeners;
    private String lastMessage;
    private boolean reportedToParent;
    private static final ThreadLocal<AtomicBoolean> recursiveCall = new ThreadLocal<AtomicBoolean>(){

        @Override
        protected AtomicBoolean initialValue() {
            return new AtomicBoolean(false);
        }
    };

    public SubProgressReceiver(ProgressReceiver progressReceiver, float offset, float extent) throws ProgressReceiver.OperationCancelled {
        this(progressReceiver, null, offset, extent);
    }

    public SubProgressReceiver(ProgressReceiver progressReceiver, String message, float offset, float extent) throws ProgressReceiver.OperationCancelled {
        if (offset < 0.0f || offset > 1.0f || extent <= 0.0f) {
            throw new IllegalArgumentException();
        }
        this.progressReceiver = progressReceiver;
        this.offset = offset;
        this.extent = extent;
        this.creationTrace = new Throwable("Creation");
        this.lastMessage = message;
    }

    public synchronized void addListener(ProgressReceiver listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<ProgressReceiver>();
        }
        this.listeners.add(listener);
    }

    public synchronized void removeListener(ProgressReceiver listener) {
        this.listeners.remove(listener);
    }

    public ProgressReceiver getParent() {
        return this.progressReceiver;
    }

    public synchronized String getLastMessage() {
        return this.lastMessage;
    }

    public Throwable getCreationTrace() {
        return this.creationTrace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProgress(float progress) throws ProgressReceiver.OperationCancelled {
        float parentProgress;
        if (!this.reportedToParent) {
            this.progressReceiver.subProgressStarted(this);
            this.reportedToParent = true;
        }
        if ((parentProgress = this.offset + progress * this.extent) < 0.0f) {
            this.progressReceiver.setProgress(0.0f);
        } else if (parentProgress > 1.0f) {
            this.progressReceiver.setProgress(1.0f);
        } else {
            this.progressReceiver.setProgress(parentProgress);
        }
        SubProgressReceiver subProgressReceiver = this;
        synchronized (subProgressReceiver) {
            if (this.listeners != null) {
                for (ProgressReceiver listener : this.listeners) {
                    listener.setProgress(progress);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exceptionThrown(Throwable exception) {
        block9: {
            if (!recursiveCall.get().get()) {
                recursiveCall.get().set(true);
                try {
                    this.progressReceiver.exceptionThrown(exception);
                    SubProgressReceiver subProgressReceiver = this;
                    synchronized (subProgressReceiver) {
                        if (this.listeners != null) {
                            for (ProgressReceiver listener : this.listeners) {
                                listener.exceptionThrown(exception);
                            }
                        }
                        break block9;
                    }
                }
                finally {
                    recursiveCall.get().set(false);
                }
            }
            this.progressReceiver.exceptionThrown(exception);
        }
    }

    @Override
    public synchronized void done() {
        if (this.listeners != null) {
            for (ProgressReceiver listener : this.listeners) {
                listener.done();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMessage(String message) throws ProgressReceiver.OperationCancelled {
        block13: {
            if (!recursiveCall.get().get()) {
                recursiveCall.get().set(true);
                try {
                    if (!this.reportedToParent) {
                        this.progressReceiver.subProgressStarted(this);
                        this.reportedToParent = true;
                    }
                    this.progressReceiver.setMessage(message);
                    SubProgressReceiver subProgressReceiver = this;
                    synchronized (subProgressReceiver) {
                        if (this.listeners != null) {
                            for (ProgressReceiver listener : this.listeners) {
                                listener.setMessage(message);
                            }
                        }
                    }
                    subProgressReceiver = this;
                    synchronized (subProgressReceiver) {
                        this.lastMessage = message;
                        break block13;
                    }
                }
                finally {
                    recursiveCall.get().set(false);
                }
            }
            this.progressReceiver.setMessage(message);
        }
    }

    @Override
    public void checkForCancellation() throws ProgressReceiver.OperationCancelled {
        this.progressReceiver.checkForCancellation();
    }

    @Override
    public void reset() {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public void subProgressStarted(SubProgressReceiver subProgressReceiver) throws ProgressReceiver.OperationCancelled {
        this.progressReceiver.subProgressStarted(subProgressReceiver);
    }
}

