/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.util.mdc;

import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.pepsoft.util.mdc.MDCWrappingRuntimeException;
import org.slf4j.MDC;

public class MDCThreadPoolExecutor
extends ThreadPoolExecutor {
    public MDCThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue);
    }

    public MDCThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
    }

    @Override
    public void execute(Runnable command) {
        super.execute(MDCThreadPoolExecutor.wrap(command));
    }

    public static ExecutorService newFixedThreadPool(int nThreads) {
        return new MDCThreadPoolExecutor(nThreads, nThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
    }

    public static ExecutorService newFixedThreadPool(int nThreads, ThreadFactory threadFactory) {
        return new MDCThreadPoolExecutor(nThreads, nThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory);
    }

    private static Runnable wrap(Runnable runnable) {
        Map mdcContextMap = MDC.getCopyOfContextMap();
        return () -> {
            if (mdcContextMap != null) {
                MDC.setContextMap((Map)mdcContextMap);
            } else {
                MDC.clear();
            }
            try {
                try {
                    runnable.run();
                }
                catch (Error | RuntimeException e) {
                    throw new MDCWrappingRuntimeException(e);
                }
            }
            finally {
                if (mdcContextMap != null) {
                    MDC.clear();
                }
            }
        };
    }
}

