/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.util;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;

public final class Version
implements Comparable<Version>,
Serializable {
    private final int[] parts;
    private final String extension;
    private static final long serialVersionUID = 1L;

    public Version(int ... parts) {
        this(parts, null);
    }

    public Version(int part0, String extension) {
        this(new int[]{part0}, extension);
    }

    public Version(int part0, int part1, String extension) {
        this(new int[]{part0, part1}, extension);
    }

    public Version(int part0, int part1, int part2, String extension) {
        this(new int[]{part0, part1, part2}, extension);
    }

    public Version(int[] parts, String extension) {
        this.parts = (int[])parts.clone();
        this.extension = extension;
        for (int part : parts) {
            if (part >= 0) continue;
            throw new IllegalArgumentException("Negative numbers not allowed");
        }
    }

    public int[] getParts() {
        return (int[])this.parts.clone();
    }

    public String getExtension() {
        return this.extension;
    }

    public boolean isAtLeast(Version version) {
        return this.compareTo(version) >= 0;
    }

    @Override
    public int compareTo(Version o) {
        for (int i = 0; i < Math.max(this.parts.length, o.parts.length); ++i) {
            if (i < this.parts.length) {
                if (i < o.parts.length) {
                    if (this.parts[i] < o.parts[i]) {
                        return -1;
                    }
                    if (this.parts[i] <= o.parts[i]) continue;
                    return 1;
                }
                if (this.parts[i] <= 0) continue;
                return 1;
            }
            if (o.parts[i] <= 0) continue;
            return -1;
        }
        if (this.extension != null) {
            if (o.extension != null) {
                return this.extension.compareTo(o.extension);
            }
            return -1;
        }
        if (o.extension != null) {
            return 1;
        }
        return 0;
    }

    public int hashCode() {
        int hash = 7;
        hash = 41 * hash + Arrays.hashCode(this.parts);
        hash = 41 * hash + Objects.hashCode(this.extension);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Version other = (Version)obj;
        if (!Arrays.equals(this.parts, other.parts)) {
            return false;
        }
        return Objects.equals(this.extension, other.extension);
    }

    public String toString() {
        return Arrays.stream(this.parts).mapToObj(Integer::toString).collect(Collectors.joining(".")) + (this.extension != null ? "-" + this.extension : "");
    }

    public static Version parse(String str) {
        String extension;
        int p = str.indexOf(45);
        if (p != -1) {
            extension = str.substring(p + 1);
            str = str.substring(0, p);
        } else {
            extension = null;
        }
        String[] partStrs = str.split("\\.");
        int[] parts = new int[partStrs.length];
        for (int i = 0; i < partStrs.length; ++i) {
            parts[i] = Integer.parseInt(partStrs[i]);
        }
        return new Version(parts, extension);
    }
}

