/*
 * Decompiled with CFR 0.152.
 */
package org.perfcake.agent;

import com.sun.management.HotSpotDiagnosticMXBean;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Properties;
import org.perfcake.agent.AgentCommand;
import org.perfcake.agent.PerfCakeAgent;

public class AgentThread
implements Runnable {
    private final String agentArgs;

    public AgentThread(String agentArgs) {
        this.agentArgs = agentArgs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        int port = 8850;
        ServerSocket serverSocket = null;
        InputStream is = null;
        try {
            Properties props = new Properties();
            if (!"".equals(this.agentArgs) && this.agentArgs != null) {
                String[] args;
                for (String arg : args = this.agentArgs.split(",")) {
                    String[] keyValuePair = arg.split("=");
                    if (keyValuePair.length == 2) {
                        props.put(keyValuePair[0], keyValuePair[1]);
                        continue;
                    }
                    AgentThread.err("Invalid agent argument \"" + arg + "\" - ignoring");
                }
            }
            if (props.get("port") != null) {
                port = Integer.parseInt((String)props.get("port"));
            }
            InetAddress host = props.get("hostname") != null ? InetAddress.getByName(props.getProperty("hostname")) : InetAddress.getLocalHost();
            serverSocket = new ServerSocket(port, 1, host);
            while (!Thread.currentThread().isInterrupted()) {
                String command;
                AgentThread.log("Listening at " + serverSocket.getInetAddress().getHostAddress() + " on port " + serverSocket.getLocalPort());
                Socket socket = serverSocket.accept();
                AgentThread.log("Client connected from " + socket.getInetAddress().getHostAddress());
                is = socket.getInputStream();
                BufferedReader br = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter(socket.getOutputStream(), "UTF-8"), true);
                while ((command = br.readLine()) != null) {
                    String response = "Unrecognized command!";
                    Runtime rt = Runtime.getRuntime();
                    try {
                        if (AgentCommand.FREE.name().equals(command)) {
                            response = String.valueOf(rt.freeMemory());
                        } else if (AgentCommand.MAX.name().equals(command)) {
                            response = String.valueOf(rt.maxMemory());
                        } else if (AgentCommand.TOTAL.name().equals(command)) {
                            response = String.valueOf(rt.totalMemory());
                        } else if (AgentCommand.USED.name().equals(command)) {
                            response = String.valueOf(rt.totalMemory() - rt.freeMemory());
                        } else if (command.startsWith(AgentCommand.DUMP.name())) {
                            int colonIndex = command.indexOf(":");
                            String dumpFileName = colonIndex >= 0 ? command.substring(colonIndex + 1) : "dump-" + System.currentTimeMillis() + ".bin";
                            int dumpNameIndex = 0;
                            File dumpFile = new File(dumpFileName);
                            while (dumpFile.exists()) {
                                AgentThread.log("WARNING: File " + dumpFileName + " already exists. Trying another file name.");
                                dumpFile = new File(dumpFileName + "." + dumpNameIndex++);
                            }
                            AgentThread.log("Saving a heap dump to " + dumpFile.getAbsolutePath());
                            try {
                                ManagementFactory.getPlatformMXBean(HotSpotDiagnosticMXBean.class).dumpHeap(dumpFile.getAbsolutePath(), true);
                                AgentThread.log("Heap dump saved to " + dumpFile.getAbsolutePath());
                                response = "0";
                            }
                            catch (IOException ioe) {
                                AgentThread.log("Error saving heap dump!");
                                ioe.printStackTrace();
                                response = "-1";
                            }
                        } else if (AgentCommand.GC.name().equals(command)) {
                            System.gc();
                            response = "0";
                        }
                    }
                    catch (IllegalArgumentException iae) {
                        AgentThread.err(iae.getLocalizedMessage());
                        response = "-1";
                    }
                    pw.println(response);
                }
                AgentThread.log("Client disconnected");
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (serverSocket != null) {
                try {
                    serverSocket.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static void log(String message) {
        System.out.println(PerfCakeAgent.class.getSimpleName() + " > " + message);
    }

    private static void err(String message) {
        System.err.println(PerfCakeAgent.class.getSimpleName() + " > ERROR: " + message);
    }
}

