/*
 * Decompiled with CFR 0.152.
 */
package org.perro.functions.collector;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.perro.functions.internal.Invariants;
import org.perro.functions.supplier.SupplierUtils;

public final class CollectorUtils {
    private CollectorUtils() {
    }

    public static <T> Collector<T, ?, List<T>> conditionalCollector(Predicate<T> shouldAddToGroup) {
        return CollectorUtils.conditionalCollector(shouldAddToGroup, ArrayList::new);
    }

    public static <T, R extends Collection<T>> Collector<T, R, R> conditionalCollector(Predicate<T> shouldAddToGroup, Supplier<R> supplier) {
        return Collector.of(supplier, CollectorUtils.accumulator(shouldAddToGroup), CollectorUtils.combiner(Collection::addAll), new Collector.Characteristics[0]);
    }

    private static <T, C extends Collection<T>> BiConsumer<C, T> accumulator(Predicate<T> shouldAddToGroup) {
        return (groupedResults, target) -> {
            if (shouldAddToGroup.test(target)) {
                groupedResults.add(target);
            }
        };
    }

    private static <T> BinaryOperator<T> combiner(BiConsumer<? super T, ? super T> biConsumer) {
        return (left, right) -> {
            biConsumer.accept(left, right);
            return left;
        };
    }

    public static <K, V> Collector<Map.Entry<K, V>, ?, Map<K, V>> toMapFromEntry() {
        return Collector.of(HashMap::new, CollectorUtils.mapEntryAccumulator(), CollectorUtils.combiner(Map::putAll), new Collector.Characteristics[0]);
    }

    private static <K, V> BiConsumer<Map<K, V>, Map.Entry<K, V>> mapEntryAccumulator() {
        return (map, entry) -> map.put(entry.getKey(), entry.getValue());
    }

    public static <T> Collector<T, ?, Stream<List<T>>> toPartitionedStream(int partitionSize) {
        return Collectors.collectingAndThen(CollectorUtils.toPartitionedList(partitionSize), Collection::stream);
    }

    public static <T> Collector<T, ?, List<List<T>>> toPartitionedList(int partitionSize) {
        Invariants.checkArgument(partitionSize > 0, "The 'partitionSize' argument must be greater than zero");
        return Collector.of(ArrayList::new, CollectorUtils.listPartitionAccumulator(partitionSize), CollectorUtils.combiner(List::addAll), new Collector.Characteristics[0]);
    }

    public static <T, R> Collector<T, List<List<T>>, List<R>> toPartitionedList(int partitionSize, Function<List<List<T>>, List<R>> finisher) {
        Invariants.checkArgument(partitionSize > 0, "The 'partitionSize' argument must be greater than zero");
        return Collector.of(ArrayList::new, CollectorUtils.listPartitionAccumulator(partitionSize), CollectorUtils.combiner(List::addAll), finisher, new Collector.Characteristics[0]);
    }

    private static <T> BiConsumer<List<List<T>>, T> listPartitionAccumulator(int partitionSize) {
        AtomicInteger batchCount = new AtomicInteger();
        AtomicInteger lastPartition = new AtomicInteger();
        return (partitions, target) -> {
            if (batchCount.intValue() % partitionSize == 0) {
                batchCount.set(0);
                lastPartition.set(partitions.size());
                partitions.add(new ArrayList());
            }
            batchCount.incrementAndGet();
            ((List)partitions.get(lastPartition.intValue())).add(target);
        };
    }

    public static Collector<Integer, ?, StringBuilder> toStringBuilder() {
        return Collector.of(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append, new Collector.Characteristics[0]);
    }

    public static <E extends Enum<E>> Collector<E, ?, EnumSet<E>> toEnumSet(Class<E> enumClass) {
        Objects.requireNonNull(enumClass, "The argument, \"enumClass\", must not be null");
        return Collector.of(SupplierUtils.supplier(EnumSet::noneOf, enumClass), CollectorUtils.accumulator(AbstractCollection::add), CollectorUtils.combiner(AbstractCollection::addAll), new Collector.Characteristics[0]);
    }

    private static <T, C extends Collection<T>> BiConsumer<C, T> accumulator(BiConsumer<C, T> biConsumer) {
        return biConsumer;
    }

    public static <T> Collector<T, ?, List<T>> toListWithDefault(T defaultElement) {
        return CollectorUtils.withDefault(defaultElement, ArrayList::new);
    }

    public static <T> Collector<T, ?, Set<T>> toSetWithDefault(T defaultElement) {
        return CollectorUtils.withDefault(defaultElement, HashSet::new);
    }

    public static <T, R extends Collection<T>> Collector<T, ?, R> withDefault(T defaultElement, Supplier<R> supplier) {
        return Collectors.collectingAndThen(Collectors.toCollection(supplier), CollectorUtils.defaultFinisher(defaultElement));
    }

    private static <T, U extends Collection<T>> UnaryOperator<U> defaultFinisher(T defaultValue) {
        return collection -> {
            if (collection.isEmpty()) {
                collection.add(defaultValue);
            }
            return collection;
        };
    }

    public static <T> Collector<T, ?, List<T>> toUnmodifiableList() {
        return Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList);
    }

    public static <T> Collector<T, ?, Set<T>> toUnmodifiableSet() {
        return Collectors.collectingAndThen(Collectors.toSet(), Collections::unmodifiableSet);
    }

    public static <T> Collector<T, ?, Collection<T>> toUnmodifiableCollection(Supplier<Collection<T>> wrappedCollectionSupplier) {
        return Collectors.collectingAndThen(Collectors.toCollection(wrappedCollectionSupplier), Collections::unmodifiableCollection);
    }

    public static <T> Collector<T, ?, List<T>> toSynchronizedList() {
        return Collectors.collectingAndThen(Collectors.toList(), Collections::synchronizedList);
    }

    public static <T> Collector<T, ?, Set<T>> toSynchronizedSet() {
        return Collectors.collectingAndThen(Collectors.toSet(), Collections::synchronizedSet);
    }

    public static <T> Collector<T, ?, Collection<T>> toSynchronizedCollection(Supplier<Collection<T>> wrappedCollectionSupplier) {
        return Collectors.collectingAndThen(Collectors.toCollection(wrappedCollectionSupplier), Collections::synchronizedCollection);
    }
}

