/*
 * Decompiled with CFR 0.152.
 */
package org.perro.functions.comparator;

import java.util.Comparator;
import java.util.function.Function;

public final class ComparatorUtils {
    private ComparatorUtils() {
    }

    public static <T extends Comparable<T>> Comparator<T> comparingNullsFirst() {
        return Comparator.nullsFirst(Comparator.naturalOrder());
    }

    public static <T, R extends Comparable<R>> Comparator<T> comparingNullsFirst(Function<? super T, ? extends R> keyExtractor) {
        return Comparator.comparing(keyExtractor, Comparator.nullsFirst(Comparator.naturalOrder()));
    }

    public static <T extends Comparable<T>> Comparator<T> comparingNullsLast() {
        return Comparator.nullsLast(Comparator.naturalOrder());
    }

    public static <T, R extends Comparable<R>> Comparator<T> comparingNullsLast(Function<? super T, ? extends R> keyExtractor) {
        return Comparator.comparing(keyExtractor, Comparator.nullsLast(Comparator.naturalOrder()));
    }
}

