/*
 * Decompiled with CFR 0.152.
 */
package org.perro.functions.consumer;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;

public final class ConsumerUtils {
    private ConsumerUtils() {
    }

    public static <T> Consumer<T> consumer(Consumer<T> consumer) {
        return consumer;
    }

    public static <T> Consumer<T> consumer(Runnable runnable) {
        return t -> runnable.run();
    }

    public static <T, U> Consumer<T> consumer(BiConsumer<? super T, ? super U> biConsumer, U value) {
        return t -> biConsumer.accept((Object)t, (Object)value);
    }

    public static <T, U> Consumer<T> inverseConsumer(BiConsumer<? super U, ? super T> biConsumer, U value) {
        return t -> biConsumer.accept((Object)value, (Object)t);
    }

    public static <T, U> Consumer<T> setter(BiConsumer<? super T, ? super U> consumer, Function<T, U> function) {
        return t -> {
            if (t != null) {
                Object value = function.apply(t);
                consumer.accept((Object)t, (Object)value);
            }
        };
    }

    public static <T, U> Consumer<T> mapAndConsume(Function<? super T, ? extends U> function, Consumer<? super U> consumer) {
        return t -> {
            if (t != null) {
                Object value = function.apply(t);
                consumer.accept((Object)value);
            }
        };
    }
}

