/*
 * Decompiled with CFR 0.152.
 */
package org.perro.functions.consumer;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleFunction;
import java.util.function.ObjDoubleConsumer;
import java.util.function.ToDoubleFunction;

public final class DblConsumerUtils {
    private DblConsumerUtils() {
    }

    public static DoubleConsumer dblConsumer(DoubleConsumer consumer) {
        return consumer;
    }

    public static DoubleConsumer dblConsumer(Runnable runnable) {
        return d -> runnable.run();
    }

    public static <U> DoubleConsumer dblConsumer(BiConsumer<Double, ? super U> biConsumer, U value) {
        return t -> biConsumer.accept(t, (Object)value);
    }

    public static <U> DoubleConsumer inverseDblConsumer(ObjDoubleConsumer<? super U> biConsumer, U value) {
        return t -> biConsumer.accept((Object)value, t);
    }

    public static <T> Consumer<T> dblSetter(BiConsumer<? super T, Double> consumer, ToDoubleFunction<T> function) {
        return t -> {
            if (t != null) {
                consumer.accept(t, function.applyAsDouble(t));
            }
        };
    }

    public static <T> Consumer<T> mapToDblAndConsume(ToDoubleFunction<? super T> function, DoubleConsumer consumer) {
        return t -> {
            if (t != null) {
                double value = function.applyAsDouble(t);
                consumer.accept(value);
            }
        };
    }

    public static <U> DoubleConsumer dblMapAndConsume(DoubleFunction<? extends U> function, Consumer<U> consumer) {
        return d -> consumer.accept(function.apply(d));
    }
}

