/*
 * Decompiled with CFR 0.152.
 */
package org.perro.functions.consumer;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import java.util.function.ObjIntConsumer;
import java.util.function.ToIntFunction;

public final class IntConsumerUtils {
    private IntConsumerUtils() {
    }

    public static IntConsumer intConsumer(IntConsumer consumer) {
        return consumer;
    }

    public static IntConsumer intConsumer(Runnable runnable) {
        return i -> runnable.run();
    }

    public static <U> IntConsumer intConsumer(BiConsumer<Integer, ? super U> biConsumer, U value) {
        return t -> biConsumer.accept(t, (Object)value);
    }

    public static <U> IntConsumer inverseIntConsumer(ObjIntConsumer<? super U> biConsumer, U value) {
        return t -> biConsumer.accept((Object)value, t);
    }

    public static <T> Consumer<T> intSetter(BiConsumer<? super T, Integer> consumer, ToIntFunction<T> function) {
        return t -> {
            if (t != null) {
                consumer.accept(t, function.applyAsInt(t));
            }
        };
    }

    public static <T> Consumer<T> mapToIntAndConsume(ToIntFunction<? super T> function, IntConsumer consumer) {
        return t -> {
            if (t != null) {
                int value = function.applyAsInt(t);
                consumer.accept(value);
            }
        };
    }

    public static <U> IntConsumer intMapAndConsume(IntFunction<? extends U> function, Consumer<U> consumer) {
        return i -> consumer.accept(function.apply(i));
    }
}

