/*
 * Decompiled with CFR 0.152.
 */
package org.perro.functions.consumer;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.LongConsumer;
import java.util.function.LongFunction;
import java.util.function.ObjLongConsumer;
import java.util.function.ToLongFunction;

public final class LongConsumerUtils {
    private LongConsumerUtils() {
    }

    public static LongConsumer longConsumer(LongConsumer consumer) {
        return consumer;
    }

    public static LongConsumer longConsumer(Runnable runnable) {
        return l -> runnable.run();
    }

    public static <U> LongConsumer longConsumer(BiConsumer<Long, ? super U> biConsumer, U value) {
        return t -> biConsumer.accept(t, (Object)value);
    }

    public static <U> LongConsumer inverseLongConsumer(ObjLongConsumer<? super U> biConsumer, U value) {
        return t -> biConsumer.accept((Object)value, t);
    }

    public static <T> Consumer<T> longSetter(BiConsumer<? super T, Long> consumer, ToLongFunction<T> extractor) {
        return t -> {
            if (t != null) {
                consumer.accept(t, extractor.applyAsLong(t));
            }
        };
    }

    public static <T> Consumer<T> mapToLongAndConsume(ToLongFunction<? super T> function, LongConsumer consumer) {
        return t -> {
            if (t != null) {
                long value = function.applyAsLong(t);
                consumer.accept(value);
            }
        };
    }

    public static <U> LongConsumer longMapAndConsume(LongFunction<? extends U> function, Consumer<U> consumer) {
        return l -> consumer.accept(function.apply(l));
    }
}

