/*
 * Decompiled with CFR 0.152.
 */
package org.perro.functions.mapper;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.DoubleFunction;
import java.util.function.DoublePredicate;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;
import java.util.function.ToDoubleBiFunction;
import java.util.function.ToDoubleFunction;
import java.util.stream.DoubleStream;
import org.perro.functions.internal.Pair;
import org.perro.functions.mapper.DblKeyValueMapper;
import org.perro.functions.mapper.DoubleIndexPair;
import org.perro.functions.mapper.DoubleObjectPair;
import org.perro.functions.mapper.DoubleTernaryMapper;
import org.perro.functions.stream.DblStreamUtils;

public final class DblMapperUtils {
    private DblMapperUtils() {
    }

    public static <R> DoubleFunction<R> dblMapper(DoubleFunction<R> function) {
        return function;
    }

    public static <U, R> DoubleFunction<R> dblMapper(BiFunction<Double, ? super U, ? extends R> biFunction, U value) {
        return d -> biFunction.apply(d, (Object)value);
    }

    public static <U, R> DoubleFunction<R> inverseDblMapper(BiFunction<? super U, Double, ? extends R> biFunction, U value) {
        return d -> biFunction.apply((Object)value, d);
    }

    public static <T> ToDoubleFunction<T> toDblMapper(ToDoubleFunction<T> function) {
        return function;
    }

    public static <T> ToDoubleFunction<T> toDblMapperDefault(ToDoubleFunction<? super T> function, double defaultValue) {
        return t -> t == null ? defaultValue : function.applyAsDouble(t);
    }

    public static <T, U> ToDoubleFunction<T> toDblMapper(ToDoubleBiFunction<? super T, ? super U> biFunction, U value) {
        return t -> biFunction.applyAsDouble((Object)t, (Object)value);
    }

    public static <T, U> ToDoubleFunction<T> inverseToDblMapper(ToDoubleBiFunction<? super U, ? super T> biFunction, U value) {
        return t -> biFunction.applyAsDouble((Object)value, (Object)t);
    }

    public static DoubleFunction<DoubleStream> dblFlatMapper(DoubleFunction<? extends double[]> doubleMapper) {
        return d -> DblStreamUtils.defaultDblStream((double[])doubleMapper.apply(d));
    }

    public static <T> Function<T, DoubleStream> flatMapperToDbl(Function<? super T, ? extends double[]> toDoubleArrayMapper) {
        return t -> t == null ? DoubleStream.empty() : DblStreamUtils.defaultDblStream((double[])toDoubleArrayMapper.apply(t));
    }

    public static <U> DoubleFunction<DoubleObjectPair<U>> dblPairOf(DoubleFunction<? extends U> rightFunction) {
        return d -> DoubleObjectPair.of(d, rightFunction.apply(d));
    }

    public static <U, V> DoubleFunction<Pair<U, V>> dblPairOf(DblKeyValueMapper<U, V> keyValueMapper) {
        return DblMapperUtils.dblPairOf(keyValueMapper.getKeyMapper(), keyValueMapper.getValueMapper());
    }

    public static <U, V> DoubleFunction<Pair<U, V>> dblPairOf(DoubleFunction<? extends U> leftFunction, DoubleFunction<? extends V> rightFunction) {
        return d -> Pair.of(leftFunction.apply(d), rightFunction.apply(d));
    }

    public static <R> DoubleFunction<DoubleObjectPair<R>> dblPairWith(List<R> pairedList) {
        ArrayList nonNullList = pairedList == null ? new ArrayList() : pairedList;
        AtomicInteger idx = new AtomicInteger();
        return d -> {
            int i = idx.getAndIncrement();
            return i < nonNullList.size() ? DoubleObjectPair.of(d, nonNullList.get(i)) : DoubleObjectPair.of(d, null);
        };
    }

    public static <U, V> DoubleFunction<Pair<U, V>> dblPairWith(DoubleFunction<? extends U> function, List<V> pairedList) {
        ArrayList nonNullList = pairedList == null ? new ArrayList() : pairedList;
        AtomicInteger idx = new AtomicInteger();
        return d -> {
            Object extracted = function.apply(d);
            int i = idx.getAndIncrement();
            return i < nonNullList.size() ? Pair.of(extracted, nonNullList.get(i)) : Pair.of(extracted, null);
        };
    }

    public static DoubleFunction<DoubleIndexPair> dblPairWithIndex() {
        AtomicInteger idx = new AtomicInteger();
        return d -> DoubleIndexPair.of(d, idx.getAndIncrement());
    }

    public static <R> DoubleFunction<Pair<R, Integer>> dblPairWithIndex(DoubleFunction<? extends R> function) {
        AtomicInteger idx = new AtomicInteger();
        return d -> Pair.of(function.apply(d), idx.getAndIncrement());
    }

    public static <R> DoubleFunction<R> dblTernary(DoublePredicate predicate, DoubleTernaryMapper<R> trueFalseMappers) {
        return d -> predicate.test(d) ? trueFalseMappers.getTrueMapper().apply(d) : trueFalseMappers.getFalseMapper().apply(d);
    }

    public static <R> DoubleTernaryMapper<R> dblTrueFalseMappers(DoubleFunction<R> trueExtractor, DoubleFunction<R> falseExtractor) {
        return DoubleTernaryMapper.of(trueExtractor, falseExtractor);
    }

    public static <K, V> DblKeyValueMapper<K, V> dblKeyValueMapper(DoubleFunction<K> keyMapper, DoubleFunction<V> valueMapper) {
        return DblKeyValueMapper.of(keyMapper, valueMapper);
    }

    public static DoubleUnaryOperator dblAdd(double toAdd) {
        return d -> d + toAdd;
    }

    public static DoubleUnaryOperator dblSubtract(double toSubtract) {
        return d -> d - toSubtract;
    }

    public static DoubleUnaryOperator dblMultiply(double factor) {
        return d -> d * factor;
    }

    public static DoubleUnaryOperator dblDivide(double divisor) {
        return d -> d / divisor;
    }

    public static DoubleUnaryOperator dblModulo(double divisor) {
        return d -> d % divisor;
    }
}

