/*
 * Decompiled with CFR 0.152.
 */
package org.perro.functions.mapper;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.DoubleFunction;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.perro.functions.collector.CollectorUtils;
import org.perro.functions.mapper.DblKeyValueMapper;
import org.perro.functions.mapper.DblMapperUtils;
import org.perro.functions.mapper.DblTransformerCollector;
import org.perro.functions.stream.DblStreamUtils;
import org.perro.functions.stream.StreamUtils;

public final class DblTransformUtils {
    private DblTransformUtils() {
    }

    public static double[] dblUnaryTransform(double[] doubles, DoubleUnaryOperator operator) {
        return DblStreamUtils.defaultDblStream(doubles).map(operator).toArray();
    }

    public static double[] dblUnaryTransformDistinct(double[] doubles, DoubleUnaryOperator operator) {
        return DblStreamUtils.defaultDblStream(doubles).map(operator).distinct().toArray();
    }

    public static <R> List<R> dblTransform(double[] doubles, DoubleFunction<R> transformer) {
        return DblTransformUtils.dblTransform(doubles, DblTransformerCollector.of(transformer, Collectors.toList()));
    }

    public static <R> Set<R> dblTransformToSet(double[] doubles, DoubleFunction<R> transformer) {
        return DblTransformUtils.dblTransform(doubles, DblTransformerCollector.of(transformer, Collectors.toSet()));
    }

    public static <C extends Collection<Double>> C dblTransform(double[] doubles, Collector<Double, ?, C> collector) {
        return DblTransformUtils.dblTransform(doubles, DblTransformerCollector.of(Double::valueOf, collector));
    }

    public static <R> List<R> dblTransformDistinct(double[] doubles, DoubleFunction<R> transformer) {
        return DblStreamUtils.defaultDblStream(doubles).mapToObj(DblMapperUtils.dblMapper(transformer)).distinct().collect(Collectors.toList());
    }

    public static <U, C extends Collection<U>> C dblTransform(double[] doubles, DblTransformerCollector<U, C> transformerCollector) {
        return (C)((Collection)DblStreamUtils.defaultDblStream(doubles).mapToObj(transformerCollector.getTransformer()).collect(transformerCollector.getCollector()));
    }

    public static double[] dblFlatMap(double[] doubles, DoubleFunction<double[]> function) {
        return DblStreamUtils.defaultDblStream(doubles).flatMap(DblMapperUtils.dblFlatMapper(function)).toArray();
    }

    public static double[] dblFlatMapDistinct(double[] doubles, DoubleFunction<double[]> function) {
        return DblStreamUtils.defaultDblStream(doubles).flatMap(DblMapperUtils.dblFlatMapper(function)).distinct().toArray();
    }

    public static <T> double[] flatMapToDbl(Collection<T> objects, Function<T, double[]> function) {
        return StreamUtils.defaultStream(objects).flatMapToDouble(DblMapperUtils.flatMapperToDbl(function)).toArray();
    }

    public static <T> double[] flatMapToDblDistinct(Collection<T> objects, Function<T, double[]> function) {
        return StreamUtils.defaultStream(objects).flatMapToDouble(DblMapperUtils.flatMapperToDbl(function)).distinct().toArray();
    }

    public static <U, C extends Collection<U>> DblTransformerCollector<U, C> dblTransformAndThen(DoubleFunction<U> transformer, Collector<U, ?, C> collector) {
        return DblTransformerCollector.of(transformer, collector);
    }

    public static <K, V> Map<K, V> dblTransformToMap(double[] doubles, DblKeyValueMapper<K, V> keyValueMapper) {
        return DblStreamUtils.defaultDblStream(doubles).mapToObj(DblMapperUtils.dblPairOf(keyValueMapper)).collect(CollectorUtils.toMapFromEntry());
    }
}

