/*
 * Decompiled with CFR 0.152.
 */
package org.perro.functions.mapper;

import java.util.Objects;

public class DoubleObjectPair<T> {
    private final double left;
    private final T right;

    private DoubleObjectPair(double left, T right) {
        this.left = left;
        this.right = right;
    }

    public static <T> DoubleObjectPair<T> of(double left, T right) {
        return new DoubleObjectPair<T>(left, right);
    }

    public double getLeft() {
        return this.left;
    }

    public T getRight() {
        return this.right;
    }

    public int hashCode() {
        return Objects.hash(this.left, this.right);
    }

    public boolean equals(Object obj) {
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        DoubleObjectPair other = (DoubleObjectPair)obj;
        return Objects.equals(this.left, other.left) && Objects.equals(this.right, other.right);
    }

    public String toString() {
        String identity = Integer.toHexString(System.identityHashCode(this));
        String template = "%s@%s[left=%s,right=%s]";
        return String.format(template, this.getClass().getName(), identity, this.left, this.right);
    }
}

