/*
 * Decompiled with CFR 0.152.
 */
package org.perro.functions.mapper;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.IntPredicate;
import java.util.function.IntUnaryOperator;
import java.util.function.ToIntBiFunction;
import java.util.function.ToIntFunction;
import java.util.stream.IntStream;
import org.perro.functions.internal.Pair;
import org.perro.functions.mapper.IntIndexPair;
import org.perro.functions.mapper.IntKeyValueMapper;
import org.perro.functions.mapper.IntObjectPair;
import org.perro.functions.mapper.IntTernaryMapper;
import org.perro.functions.stream.IntStreamUtils;

public final class IntMapperUtils {
    private IntMapperUtils() {
    }

    public static <R> IntFunction<R> intMapper(IntFunction<R> function) {
        return function;
    }

    public static <U, R> IntFunction<R> intMapper(BiFunction<Integer, ? super U, ? extends R> biFunction, U value) {
        return i -> biFunction.apply(i, (Object)value);
    }

    public static <U, R> IntFunction<R> inverseIntMapper(BiFunction<? super U, Integer, ? extends R> biFunction, U value) {
        return i -> biFunction.apply((Object)value, i);
    }

    public static <T> ToIntFunction<T> toIntMapper(ToIntFunction<T> function) {
        return function;
    }

    public static <T> ToIntFunction<T> toIntMapperDefault(ToIntFunction<? super T> function, int defaultValue) {
        return t -> t == null ? defaultValue : function.applyAsInt(t);
    }

    public static <T, U> ToIntFunction<T> toIntMapper(ToIntBiFunction<? super T, ? super U> biFunction, U value) {
        return t -> biFunction.applyAsInt((Object)t, (Object)value);
    }

    public static <T, U> ToIntFunction<T> inverseToIntMapper(ToIntBiFunction<? super U, ? super T> biFunction, U value) {
        return t -> biFunction.applyAsInt((Object)value, (Object)t);
    }

    public static IntFunction<IntStream> intFlatMapper(IntFunction<? extends int[]> intMapper) {
        return i -> IntStreamUtils.defaultIntStream((int[])intMapper.apply(i));
    }

    public static <T> Function<T, IntStream> flatMapperToInt(Function<? super T, ? extends int[]> toIntArrayMapper) {
        return t -> t == null ? IntStream.empty() : IntStreamUtils.defaultIntStream((int[])toIntArrayMapper.apply(t));
    }

    public static <U> IntFunction<IntObjectPair<U>> intPairOf(IntFunction<? extends U> rightFunction) {
        return i -> IntObjectPair.of(i, rightFunction.apply(i));
    }

    public static <U, V> IntFunction<Pair<U, V>> intPairOf(IntKeyValueMapper<U, V> keyValueMapper) {
        return IntMapperUtils.intPairOf(keyValueMapper.getKeyMapper(), keyValueMapper.getValueMapper());
    }

    public static <U, V> IntFunction<Pair<U, V>> intPairOf(IntFunction<? extends U> leftFunction, IntFunction<? extends V> rightFunction) {
        return i -> Pair.of(leftFunction.apply(i), rightFunction.apply(i));
    }

    public static <R> IntFunction<IntObjectPair<R>> intPairWith(List<R> pairedList) {
        ArrayList nonNullList = pairedList == null ? new ArrayList() : pairedList;
        AtomicInteger idx = new AtomicInteger();
        return i -> {
            int j = idx.getAndIncrement();
            return j < nonNullList.size() ? IntObjectPair.of(i, nonNullList.get(j)) : IntObjectPair.of(i, null);
        };
    }

    public static <U, V> IntFunction<Pair<U, V>> intPairWith(IntFunction<? extends U> function, List<V> pairedList) {
        ArrayList nonNullList = pairedList == null ? new ArrayList() : pairedList;
        AtomicInteger idx = new AtomicInteger();
        return i -> {
            Object extracted = function.apply(i);
            int j = idx.getAndIncrement();
            return j < nonNullList.size() ? Pair.of(extracted, nonNullList.get(j)) : Pair.of(extracted, null);
        };
    }

    public static IntFunction<IntIndexPair> intPairWithIndex() {
        AtomicInteger idx = new AtomicInteger();
        return i -> IntIndexPair.of(i, idx.getAndIncrement());
    }

    public static <R> IntFunction<Pair<R, Integer>> intPairWithIndex(IntFunction<? extends R> function) {
        AtomicInteger idx = new AtomicInteger();
        return i -> Pair.of(function.apply(i), idx.getAndIncrement());
    }

    public static <R> IntFunction<R> intTernary(IntPredicate predicate, IntTernaryMapper<R> trueFalseMappers) {
        return i -> predicate.test(i) ? trueFalseMappers.getTrueMapper().apply(i) : trueFalseMappers.getFalseMapper().apply(i);
    }

    public static <R> IntTernaryMapper<R> intTrueFalseMappers(IntFunction<R> trueExtractor, IntFunction<R> falseExtractor) {
        return IntTernaryMapper.of(trueExtractor, falseExtractor);
    }

    public static <K, V> IntKeyValueMapper<K, V> intKeyValueMapper(IntFunction<K> keyMapper, IntFunction<V> valueMapper) {
        return IntKeyValueMapper.of(keyMapper, valueMapper);
    }

    public static IntUnaryOperator intAdd(int toAdd) {
        return i -> i + toAdd;
    }

    public static IntUnaryOperator intSubtract(int toSubtract) {
        return i -> i - toSubtract;
    }

    public static IntUnaryOperator intMultiply(int factor) {
        return i -> i * factor;
    }

    public static IntUnaryOperator intDivide(int divisor) {
        return i -> i / divisor;
    }

    public static IntUnaryOperator intModulo(int divisor) {
        return i -> i % divisor;
    }
}

