/*
 * Decompiled with CFR 0.152.
 */
package org.perro.functions.mapper;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.IntUnaryOperator;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.perro.functions.collector.CollectorUtils;
import org.perro.functions.mapper.IntKeyValueMapper;
import org.perro.functions.mapper.IntMapperUtils;
import org.perro.functions.mapper.IntTransformerCollector;
import org.perro.functions.stream.IntStreamUtils;
import org.perro.functions.stream.StreamUtils;

public final class IntTransformUtils {
    private IntTransformUtils() {
    }

    public static int[] intUnaryTransform(int[] ints, IntUnaryOperator operator) {
        return IntStreamUtils.defaultIntStream(ints).map(operator).toArray();
    }

    public static int[] intUnaryTransformDistinct(int[] ints, IntUnaryOperator operator) {
        return IntStreamUtils.defaultIntStream(ints).map(operator).distinct().toArray();
    }

    public static <R> List<R> intTransform(int[] ints, IntFunction<R> transformer) {
        return IntTransformUtils.intTransform(ints, IntTransformerCollector.of(transformer, Collectors.toList()));
    }

    public static <R> Set<R> intTransformToSet(int[] ints, IntFunction<R> transformer) {
        return IntTransformUtils.intTransform(ints, IntTransformerCollector.of(transformer, Collectors.toSet()));
    }

    public static <C extends Collection<Integer>> C intTransform(int[] ints, Collector<Integer, ?, C> collector) {
        return IntTransformUtils.intTransform(ints, IntTransformerCollector.of(Integer::valueOf, collector));
    }

    public static <R> List<R> intTransformDistinct(int[] ints, IntFunction<R> transformer) {
        return IntStreamUtils.defaultIntStream(ints).mapToObj(IntMapperUtils.intMapper(transformer)).distinct().collect(Collectors.toList());
    }

    public static <U, C extends Collection<U>> C intTransform(int[] ints, IntTransformerCollector<U, C> transformerCollector) {
        return (C)((Collection)IntStreamUtils.defaultIntStream(ints).mapToObj(transformerCollector.getTransformer()).collect(transformerCollector.getCollector()));
    }

    public static int[] intFlatMap(int[] ints, IntFunction<int[]> function) {
        return IntStreamUtils.defaultIntStream(ints).flatMap(IntMapperUtils.intFlatMapper(function)).toArray();
    }

    public static int[] intFlatMapDistinct(int[] ints, IntFunction<int[]> function) {
        return IntStreamUtils.defaultIntStream(ints).flatMap(IntMapperUtils.intFlatMapper(function)).distinct().toArray();
    }

    public static <T> int[] flatMapToInt(Collection<T> objects, Function<T, int[]> function) {
        return StreamUtils.defaultStream(objects).flatMapToInt(IntMapperUtils.flatMapperToInt(function)).toArray();
    }

    public static <T> int[] flatMapToIntDistinct(Collection<T> objects, Function<T, int[]> function) {
        return StreamUtils.defaultStream(objects).flatMapToInt(IntMapperUtils.flatMapperToInt(function)).distinct().toArray();
    }

    public static <U, C extends Collection<U>> IntTransformerCollector<U, C> intTransformAndThen(IntFunction<U> transformer, Collector<U, ?, C> collector) {
        return IntTransformerCollector.of(transformer, collector);
    }

    public static <K, V> Map<K, V> intTransformToMap(int[] ints, IntKeyValueMapper<K, V> keyValueMapper) {
        return IntStreamUtils.defaultIntStream(ints).mapToObj(IntMapperUtils.intPairOf(keyValueMapper)).collect(CollectorUtils.toMapFromEntry());
    }
}

