/*
 * Decompiled with CFR 0.152.
 */
package org.perro.functions.mapper;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.LongFunction;
import java.util.function.LongPredicate;
import java.util.function.LongUnaryOperator;
import java.util.function.ToLongBiFunction;
import java.util.function.ToLongFunction;
import java.util.stream.LongStream;
import org.perro.functions.internal.Pair;
import org.perro.functions.mapper.LongIndexPair;
import org.perro.functions.mapper.LongKeyValueMapper;
import org.perro.functions.mapper.LongObjectPair;
import org.perro.functions.mapper.LongTernaryMapper;
import org.perro.functions.stream.LongStreamUtils;

public final class LongMapperUtils {
    private LongMapperUtils() {
    }

    public static <R> LongFunction<R> longMapper(LongFunction<R> function) {
        return function;
    }

    public static <U, R> LongFunction<R> longMapper(BiFunction<Long, ? super U, ? extends R> biFunction, U value) {
        return l -> biFunction.apply(l, (Object)value);
    }

    public static <U, R> LongFunction<R> inverseLongMapper(BiFunction<? super U, Long, ? extends R> biFunction, U value) {
        return l -> biFunction.apply((Object)value, l);
    }

    public static <T> ToLongFunction<T> toLongMapper(ToLongFunction<T> function) {
        return function;
    }

    public static <T> ToLongFunction<T> toLongMapperDefault(ToLongFunction<? super T> function, long defaultValue) {
        return t -> t == null ? defaultValue : function.applyAsLong(t);
    }

    public static <T, U> ToLongFunction<T> toLongMapper(ToLongBiFunction<? super T, ? super U> biFunction, U value) {
        return t -> biFunction.applyAsLong((Object)t, (Object)value);
    }

    public static <T, U> ToLongFunction<T> inverseToLongMapper(ToLongBiFunction<? super U, ? super T> biFunction, U value) {
        return t -> biFunction.applyAsLong((Object)value, (Object)t);
    }

    public static LongFunction<LongStream> longFlatMapper(LongFunction<? extends long[]> longMapper) {
        return l -> LongStreamUtils.defaultLongStream((long[])longMapper.apply(l));
    }

    public static <T> Function<T, LongStream> flatMapperToLong(Function<? super T, ? extends long[]> toLongArrayMapper) {
        return t -> t == null ? LongStream.empty() : LongStreamUtils.defaultLongStream((long[])toLongArrayMapper.apply(t));
    }

    public static <U> LongFunction<LongObjectPair<U>> longPairOf(LongFunction<? extends U> rightFunction) {
        return l -> LongObjectPair.of(l, rightFunction.apply(l));
    }

    public static <U, V> LongFunction<Pair<U, V>> longPairOf(LongKeyValueMapper<U, V> keyValueMapper) {
        return LongMapperUtils.longPairOf(keyValueMapper.getKeyMapper(), keyValueMapper.getValueMapper());
    }

    public static <U, V> LongFunction<Pair<U, V>> longPairOf(LongFunction<? extends U> leftFunction, LongFunction<? extends V> rightFunction) {
        return l -> Pair.of(leftFunction.apply(l), rightFunction.apply(l));
    }

    public static <R> LongFunction<LongObjectPair<R>> longPairWith(List<R> pairedList) {
        ArrayList nonNullList = pairedList == null ? new ArrayList() : pairedList;
        AtomicInteger idx = new AtomicInteger();
        return l -> {
            int i = idx.getAndIncrement();
            return i < nonNullList.size() ? LongObjectPair.of(l, nonNullList.get(i)) : LongObjectPair.of(l, null);
        };
    }

    public static <U, V> LongFunction<Pair<U, V>> longPairWith(LongFunction<? extends U> function, List<V> pairedList) {
        ArrayList nonNullList = pairedList == null ? new ArrayList() : pairedList;
        AtomicInteger idx = new AtomicInteger();
        return l -> {
            Object extracted = function.apply(l);
            int i = idx.getAndIncrement();
            return i < nonNullList.size() ? Pair.of(extracted, nonNullList.get(i)) : Pair.of(extracted, null);
        };
    }

    public static LongFunction<LongIndexPair> longPairWithIndex() {
        AtomicInteger idx = new AtomicInteger();
        return l -> LongIndexPair.of(l, idx.getAndIncrement());
    }

    public static <R> LongFunction<Pair<R, Integer>> longPairWithIndex(LongFunction<? extends R> function) {
        AtomicInteger idx = new AtomicInteger();
        return l -> Pair.of(function.apply(l), idx.getAndIncrement());
    }

    public static <R> LongFunction<R> longTernary(LongPredicate predicate, LongTernaryMapper<R> trueFalseMappers) {
        return l -> predicate.test(l) ? trueFalseMappers.getTrueMapper().apply(l) : trueFalseMappers.getFalseMapper().apply(l);
    }

    public static <R> LongTernaryMapper<R> longTrueFalseMappers(LongFunction<R> trueExtractor, LongFunction<R> falseExtractor) {
        return LongTernaryMapper.of(trueExtractor, falseExtractor);
    }

    public static <K, V> LongKeyValueMapper<K, V> longKeyValueMapper(LongFunction<K> keyMapper, LongFunction<V> valueMapper) {
        return LongKeyValueMapper.of(keyMapper, valueMapper);
    }

    public static LongUnaryOperator longAdd(long toAdd) {
        return l -> l + toAdd;
    }

    public static LongUnaryOperator longSubtract(long toSubtract) {
        return l -> l - toSubtract;
    }

    public static LongUnaryOperator longMultiply(long factor) {
        return l -> l * factor;
    }

    public static LongUnaryOperator longDivide(long divisor) {
        return l -> l / divisor;
    }

    public static LongUnaryOperator longModulo(long divisor) {
        return l -> l % divisor;
    }
}

