/*
 * Decompiled with CFR 0.152.
 */
package org.perro.functions.mapper;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.LongFunction;
import java.util.function.LongUnaryOperator;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.perro.functions.collector.CollectorUtils;
import org.perro.functions.mapper.LongKeyValueMapper;
import org.perro.functions.mapper.LongMapperUtils;
import org.perro.functions.mapper.LongTransformerCollector;
import org.perro.functions.stream.LongStreamUtils;
import org.perro.functions.stream.StreamUtils;

public final class LongTransformUtils {
    private LongTransformUtils() {
    }

    public static long[] longUnaryTransform(long[] longs, LongUnaryOperator operator) {
        return LongStreamUtils.defaultLongStream(longs).map(operator).toArray();
    }

    public static long[] longUnaryTransformDistinct(long[] longs, LongUnaryOperator operator) {
        return LongStreamUtils.defaultLongStream(longs).map(operator).distinct().toArray();
    }

    public static <R> List<R> longTransform(long[] longs, LongFunction<R> transformer) {
        return LongTransformUtils.longTransform(longs, LongTransformerCollector.of(transformer, Collectors.toList()));
    }

    public static <R> Set<R> longTransformToSet(long[] longs, LongFunction<R> transformer) {
        return LongTransformUtils.longTransform(longs, LongTransformerCollector.of(transformer, Collectors.toSet()));
    }

    public static <C extends Collection<Long>> C longTransform(long[] longs, Collector<Long, ?, C> collector) {
        return LongTransformUtils.longTransform(longs, LongTransformerCollector.of(Long::valueOf, collector));
    }

    public static <R> List<R> longTransformDistinct(long[] longs, LongFunction<R> transformer) {
        return LongStreamUtils.defaultLongStream(longs).mapToObj(LongMapperUtils.longMapper(transformer)).distinct().collect(Collectors.toList());
    }

    public static <U, C extends Collection<U>> C longTransform(long[] longs, LongTransformerCollector<U, C> transformerCollector) {
        return (C)((Collection)LongStreamUtils.defaultLongStream(longs).mapToObj(transformerCollector.getTransformer()).collect(transformerCollector.getCollector()));
    }

    public static long[] longFlatMap(long[] longs, LongFunction<long[]> function) {
        return LongStreamUtils.defaultLongStream(longs).flatMap(LongMapperUtils.longFlatMapper(function)).toArray();
    }

    public static long[] longFlatMapDistinct(long[] longs, LongFunction<long[]> function) {
        return LongStreamUtils.defaultLongStream(longs).flatMap(LongMapperUtils.longFlatMapper(function)).distinct().toArray();
    }

    public static <T> long[] flatMapToLong(Collection<T> objects, Function<T, long[]> function) {
        return StreamUtils.defaultStream(objects).flatMapToLong(LongMapperUtils.flatMapperToLong(function)).toArray();
    }

    public static <T> long[] flatMapToLongDistinct(Collection<T> objects, Function<T, long[]> function) {
        return StreamUtils.defaultStream(objects).flatMapToLong(LongMapperUtils.flatMapperToLong(function)).distinct().toArray();
    }

    public static <U, C extends Collection<U>> LongTransformerCollector<U, C> longTransformAndThen(LongFunction<U> transformer, Collector<U, ?, C> collector) {
        return LongTransformerCollector.of(transformer, collector);
    }

    public static <K, V> Map<K, V> longTransformToMap(long[] longs, LongKeyValueMapper<K, V> keyValueMapper) {
        return LongStreamUtils.defaultLongStream(longs).mapToObj(LongMapperUtils.longPairOf(keyValueMapper)).collect(CollectorUtils.toMapFromEntry());
    }
}

