/*
 * Decompiled with CFR 0.152.
 */
package org.perro.functions.mapper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import org.perro.functions.internal.Pair;
import org.perro.functions.mapper.KeyValueMapper;
import org.perro.functions.mapper.ObjectIndexPair;
import org.perro.functions.mapper.TrueFalseMappers;
import org.perro.functions.stream.StreamUtils;

public final class MapperUtils {
    private MapperUtils() {
    }

    public static <T, R> Function<T, R> mapper(Function<T, R> function) {
        return t -> t == null ? null : function.apply(t);
    }

    public static <T, R> Function<T, R> mapperIgnoringTarget(Supplier<R> supplier) {
        return t -> supplier.get();
    }

    public static <T, U, R> Function<T, R> mapperIgnoringTarget(Function<U, R> function, U value) {
        return t -> function.apply(value);
    }

    public static <T> UnaryOperator<T> mapperDefault(T defaultValue) {
        return t -> t == null ? defaultValue : t;
    }

    public static <T> UnaryOperator<T> mapperDefault(Supplier<T> defaultSupplier) {
        return t -> t == null ? defaultSupplier.get() : t;
    }

    public static <T, R> Function<T, R> mapperDefault(Function<? super T, ? extends R> function, R defaultValue) {
        return t -> t == null || function.apply(t) == null ? defaultValue : function.apply(t);
    }

    public static <T, R> Function<T, R> mapperDefault(Function<? super T, ? extends R> function, Supplier<R> defaultSupplier) {
        return t -> t == null || function.apply(t) == null ? defaultSupplier.get() : function.apply(t);
    }

    public static <T, U, R> Function<T, R> mapper(BiFunction<? super T, ? super U, ? extends R> biFunction, U value) {
        return t -> biFunction.apply((Object)t, (Object)value);
    }

    public static <T, U, R> Function<T, R> inverseMapper(BiFunction<? super U, ? super T, ? extends R> biFunction, U value) {
        return t -> biFunction.apply((Object)value, (Object)t);
    }

    public static <T, U, R> Function<T, R> mapper(Function<? super T, ? extends U> left, Function<? super U, ? extends R> right) {
        return t -> {
            Object value = t == null ? null : (Object)left.apply(t);
            return value == null ? null : right.apply((Object)value);
        };
    }

    public static <T, K, V> Function<T, V> getValue(Map<K, V> map, Function<T, K> function) {
        return t -> map == null || t == null ? null : map.get(function.apply(t));
    }

    public static <T, R> Function<T, Stream<R>> flatMapper(Function<? super T, ? extends Collection<R>> function) {
        return t -> t == null ? Stream.empty() : StreamUtils.defaultStream((Collection)function.apply(t));
    }

    public static <T, R> Function<T, Stream<R>> flatArrayMapper(Function<? super T, ? extends R[]> function) {
        return t -> t == null ? Stream.empty() : StreamUtils.defaultStream((Object[])function.apply(t));
    }

    public static <T, U> Function<T, Pair<T, U>> pairOf(Function<? super T, ? extends U> rightFunction) {
        return MapperUtils.pairOf(Function.identity(), rightFunction);
    }

    public static <T, U, V> Function<T, Pair<U, V>> pairOf(KeyValueMapper<T, U, V> keyValueMapper) {
        return MapperUtils.pairOf(keyValueMapper.getKeyMapper(), keyValueMapper.getValueMapper());
    }

    public static <T, U, V> Function<T, Pair<U, V>> pairOf(Function<T, U> leftFunction, Function<? super T, ? extends V> rightFunction) {
        return t -> Pair.of(MapperUtils.mapper(leftFunction).apply(t), MapperUtils.mapper(rightFunction).apply(t));
    }

    public static <T, R> Function<T, Pair<T, R>> pairWith(List<R> pairedList) {
        return MapperUtils.pairWith(Function.identity(), pairedList);
    }

    public static <T, U, V> Function<T, Pair<U, V>> pairWith(Function<? super T, ? extends U> function, List<V> pairedList) {
        ArrayList nonNullList = pairedList == null ? new ArrayList() : pairedList;
        AtomicInteger idx = new AtomicInteger();
        return t -> {
            Object extracted = t == null ? null : (Object)function.apply(t);
            int i = idx.getAndIncrement();
            return i < nonNullList.size() ? Pair.of(extracted, nonNullList.get(i)) : Pair.of(extracted, null);
        };
    }

    public static <T> Function<T, ObjectIndexPair<T>> pairWithIndex() {
        return MapperUtils.pairWithIndex(Function.identity());
    }

    public static <T, R> Function<T, ObjectIndexPair<R>> pairWithIndex(Function<? super T, ? extends R> function) {
        AtomicInteger idx = new AtomicInteger();
        return t -> ObjectIndexPair.of(function.apply(t), idx.getAndIncrement());
    }

    public static <T, R> Function<T, R> ternary(Predicate<T> predicate, TrueFalseMappers<T, R> ternaryMapper) {
        return t -> t != null && predicate.test(t) ? ternaryMapper.getTrueMapper().apply(t) : ternaryMapper.getFalseMapper().apply(t);
    }

    public static <T, R> TrueFalseMappers<T, R> trueFalseMappers(Function<T, R> trueExtractor, Function<T, R> falseExtractor) {
        return TrueFalseMappers.of(trueExtractor, falseExtractor);
    }

    public static <T, K, V> KeyValueMapper<T, K, V> keyValueMapper(Function<T, K> keyMapper, Function<T, V> valueMapper) {
        return KeyValueMapper.of(keyMapper, valueMapper);
    }
}

