/*
 * Decompiled with CFR 0.152.
 */
package org.perro.functions.mapper;

import java.util.Objects;

public class ObjectIndexPair<T> {
    private final T object;
    private final int index;

    private ObjectIndexPair(T object, int index) {
        this.object = object;
        this.index = index;
    }

    public static <T> ObjectIndexPair<T> of(T object, int index) {
        return new ObjectIndexPair<T>(object, index);
    }

    public T getObject() {
        return this.object;
    }

    public int getIndex() {
        return this.index;
    }

    public int hashCode() {
        return Objects.hash(this.object, this.index);
    }

    public boolean equals(Object obj) {
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        ObjectIndexPair other = (ObjectIndexPair)obj;
        return Objects.equals(this.object, other.object) && this.index == other.index;
    }

    public String toString() {
        String identity = Integer.toHexString(System.identityHashCode(this));
        String template = "%s@%s[object=%s,index=%s]";
        return String.format(template, this.getClass().getName(), identity, this.object, this.index);
    }
}

