/*
 * Decompiled with CFR 0.152.
 */
package org.perro.functions.mapper;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.perro.functions.collector.CollectorUtils;
import org.perro.functions.mapper.FlatMapCollector;
import org.perro.functions.mapper.KeyValueMapper;
import org.perro.functions.mapper.MapperUtils;
import org.perro.functions.mapper.TransformerCollector;
import org.perro.functions.stream.StreamUtils;

public final class TransformUtils {
    private TransformUtils() {
    }

    public static <T, R> List<R> transform(Collection<T> objects, Function<T, R> transformer) {
        return TransformUtils.transform(objects, TransformerCollector.of(transformer, Collectors.toList()));
    }

    public static <T, R> Set<R> transformToSet(Collection<T> objects, Function<T, R> transformer) {
        return TransformUtils.transform(objects, TransformerCollector.of(transformer, Collectors.toSet()));
    }

    public static <T, R> List<R> transformDistinct(Collection<T> objects, Function<T, R> transformer) {
        return StreamUtils.defaultStream(objects).map(transformer).distinct().collect(Collectors.toList());
    }

    public static <T, U, C extends Collection<U>> C transform(Collection<T> objects, TransformerCollector<T, U, C> transformerCollector) {
        return (C)((Collection)StreamUtils.defaultStream(objects).map(transformerCollector.getTransformer()).collect(transformerCollector.getCollector()));
    }

    public static <T, K, V> Map<K, V> transformToMap(Collection<T> objects, KeyValueMapper<T, K, V> keyValueMapper) {
        return StreamUtils.defaultStream(objects).map(MapperUtils.pairOf(keyValueMapper)).collect(CollectorUtils.toMapFromEntry());
    }

    public static <T, U> List<U> flatMap(Collection<T> objects, Function<T, Collection<U>> function) {
        FlatMapCollector flatMapCollector = FlatMapCollector.of(function, Collectors.toList());
        return TransformUtils.flatMap(objects, flatMapCollector);
    }

    public static <T, R> Set<R> flatMapToSet(Collection<T> objects, Function<T, Collection<R>> function) {
        return TransformUtils.flatMap(objects, FlatMapCollector.of(function, Collectors.toSet()));
    }

    public static <T, U> List<U> flatMapDistinct(Collection<T> objects, Function<T, Collection<U>> function) {
        return StreamUtils.defaultStream(objects).flatMap(MapperUtils.flatMapper(function)).distinct().collect(Collectors.toList());
    }

    public static <T, U, C extends Collection<U>> C flatMap(Collection<T> objects, FlatMapCollector<T, U, C> flatMapCollector) {
        return (C)((Collection)StreamUtils.defaultStream(objects).flatMap(flatMapCollector.getFlatMapper()).collect(flatMapCollector.getCollector()));
    }

    public static <T, U, C extends Collection<U>> TransformerCollector<T, U, C> transformAndThen(Function<T, U> transformer, Collector<U, ?, C> collector) {
        return TransformerCollector.of(transformer, collector);
    }

    public static <T, U, C extends Collection<U>> FlatMapCollector<T, U, C> flatMapAndThen(Function<T, Collection<U>> flatMapper, Collector<U, ?, C> collector) {
        return FlatMapCollector.of(flatMapper, collector);
    }
}

