/*
 * Decompiled with CFR 0.152.
 */
package org.perro.functions.predicate;

import java.util.function.Predicate;
import org.perro.functions.mapper.IntIndexPair;
import org.perro.functions.mapper.IntMapperUtils;

class CharSequenceEqualityEvaluator {
    private final CharSequence left;
    private final CharSequence right;

    CharSequenceEqualityEvaluator(CharSequence left, CharSequence right) {
        this.left = left;
        this.right = right;
    }

    boolean equals() {
        return this.evaluate(this::isCodePointEqual);
    }

    private boolean isCodePointEqual(IntIndexPair pair) {
        return pair.getIntValue() == this.right.charAt(pair.getIndex());
    }

    private boolean evaluate(Predicate<IntIndexPair> matchPredicate) {
        return this.left == this.right || this.neitherAreNull() && this.lengthsAreEqual() && this.allCodePointsMatch(matchPredicate);
    }

    private boolean neitherAreNull() {
        return this.left != null && this.right != null;
    }

    private boolean lengthsAreEqual() {
        return this.left.length() == this.right.length();
    }

    private boolean allCodePointsMatch(Predicate<IntIndexPair> matchPredicate) {
        return this.left.codePoints().mapToObj(IntMapperUtils.intPairWithIndex()).allMatch(matchPredicate);
    }

    boolean equalsIgnoreCase() {
        return this.evaluate(this::isCodePointEqualIgnoreCase);
    }

    private boolean isCodePointEqualIgnoreCase(IntIndexPair pair) {
        int leftChar = pair.getIntValue();
        char rightChar = this.right.charAt(pair.getIndex());
        return Character.toUpperCase(leftChar) == Character.toUpperCase((int)rightChar) || Character.toLowerCase(leftChar) == Character.toLowerCase((int)rightChar);
    }
}

