/*
 * Decompiled with CFR 0.152.
 */
package org.perro.functions.predicate;

import java.util.function.BiPredicate;
import java.util.stream.IntStream;
import org.perro.functions.predicate.CharSequenceUtils;
import org.perro.functions.predicate.IntPredicateUtils;

class CharSequenceMatcher {
    private final CharSequence target;
    private final CharSequence searchSequence;

    CharSequenceMatcher(CharSequence target, CharSequence searchSequence) {
        this.target = target;
        this.searchSequence = searchSequence;
    }

    boolean containsSearchSequence() {
        return this.target != null && this.searchSequence != null && (this.bothSequencesAreEmpty() || this.containsAllCodePoints(CharSequenceUtils::equals));
    }

    private boolean bothSequencesAreEmpty() {
        return this.target.length() == 0 && this.searchSequence.length() == 0;
    }

    private boolean containsAllCodePoints(BiPredicate<CharSequence, CharSequence> equalityPredicate) {
        return IntStream.range(0, this.target.length()).anyMatch(IntPredicateUtils.intPredicate(this::indexWithinLimit).and(IntPredicateUtils.intPredicate(this::sequenceMatches, equalityPredicate)));
    }

    private boolean indexWithinLimit(int index) {
        return this.target.length() >= index + this.searchSequence.length();
    }

    private boolean sequenceMatches(int index, BiPredicate<CharSequence, CharSequence> equalityPredicate) {
        int searchLength = this.searchSequence.length();
        CharSequence targetSubSequence = this.target.subSequence(index, index + searchLength);
        return equalityPredicate.test(targetSubSequence, this.searchSequence);
    }

    boolean containsSearchSequenceIgnoreCase() {
        return this.target != null && this.searchSequence != null && (this.bothSequencesAreEmpty() || this.containsAllCodePoints(CharSequenceUtils::equalsIgnoreCase));
    }
}

