/*
 * Decompiled with CFR 0.152.
 */
package org.perro.functions.predicate;

import java.util.function.IntPredicate;
import org.perro.functions.predicate.CharSequenceEqualityEvaluator;
import org.perro.functions.predicate.CharSequenceMatcher;
import org.perro.functions.predicate.IntPredicateUtils;

final class CharSequenceUtils {
    private CharSequenceUtils() {
    }

    static boolean equals(CharSequence left, CharSequence right) {
        return new CharSequenceEqualityEvaluator(left, right).equals();
    }

    static boolean equalsIgnoreCase(CharSequence left, CharSequence right) {
        return new CharSequenceEqualityEvaluator(left, right).equalsIgnoreCase();
    }

    static boolean contains(CharSequence sequence, int searchChar) {
        return sequence != null && sequence.codePoints().anyMatch(IntPredicateUtils.isIntEqual(searchChar));
    }

    static boolean containsIgnoreCase(CharSequence sequence, int searchChar) {
        int lowerSearchChar = Character.toLowerCase(searchChar);
        return sequence != null && sequence.codePoints().map(Character::toLowerCase).anyMatch(IntPredicateUtils.isIntEqual(lowerSearchChar));
    }

    static boolean contains(CharSequence sequence, CharSequence searchSequence) {
        return new CharSequenceMatcher(sequence, searchSequence).containsSearchSequence();
    }

    static boolean containsIgnoreCase(CharSequence sequence, CharSequence searchSequence) {
        return new CharSequenceMatcher(sequence, searchSequence).containsSearchSequenceIgnoreCase();
    }

    static boolean anyCharacterMatches(CharSequence sequence, IntPredicate charPredicate) {
        return sequence != null && sequence.codePoints().anyMatch(charPredicate);
    }

    static boolean isCharacterMatch(CharSequence sequence, IntPredicate charPredicate) {
        return sequence != null && sequence.codePoints().allMatch(charPredicate);
    }

    static boolean noCharactersMatch(CharSequence sequence, IntPredicate charPredicate) {
        return sequence == null || sequence.codePoints().noneMatch(charPredicate);
    }

    static boolean startsWith(CharSequence sequence, CharSequence prefix) {
        return sequence == prefix || CharSequenceUtils.neitherAreNull(sequence, prefix) && sequence.length() >= prefix.length() && CharSequenceUtils.equals(CharSequenceUtils.getStartsWithSubSequence(sequence, prefix), prefix);
    }

    private static boolean neitherAreNull(CharSequence left, CharSequence right) {
        return left != null && right != null;
    }

    private static CharSequence getStartsWithSubSequence(CharSequence sequence, CharSequence prefix) {
        return sequence.subSequence(0, prefix.length());
    }

    static boolean startsWithIgnoreCase(CharSequence sequence, CharSequence prefix) {
        return sequence == prefix || CharSequenceUtils.neitherAreNull(sequence, prefix) && sequence.length() >= prefix.length() && CharSequenceUtils.equalsIgnoreCase(CharSequenceUtils.getStartsWithSubSequence(sequence, prefix), prefix);
    }

    static boolean endsWith(CharSequence sequence, CharSequence suffix) {
        return sequence == suffix || CharSequenceUtils.neitherAreNull(sequence, suffix) && sequence.length() >= suffix.length() && CharSequenceUtils.equals(CharSequenceUtils.getEndsWithSubSequence(sequence, suffix), suffix);
    }

    private static CharSequence getEndsWithSubSequence(CharSequence sequence, CharSequence suffix) {
        int len = sequence.length();
        return sequence.subSequence(len - suffix.length(), len);
    }

    static boolean endsWithIgnoreCase(CharSequence sequence, CharSequence suffix) {
        return sequence == suffix || CharSequenceUtils.neitherAreNull(sequence, suffix) && sequence.length() >= suffix.length() && CharSequenceUtils.equalsIgnoreCase(CharSequenceUtils.getEndsWithSubSequence(sequence, suffix), suffix);
    }

    static boolean isNullOrEmpty(CharSequence sequence) {
        return sequence == null || sequence.length() == 0;
    }
}

