/*
 * Decompiled with CFR 0.152.
 */
package org.perro.functions.predicate;

import java.util.Collection;
import java.util.Set;
import java.util.function.DoublePredicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.perro.functions.predicate.DoubleFilterCollector;
import org.perro.functions.stream.DblStreamUtils;

public final class DblFilterUtils {
    private DblFilterUtils() {
    }

    public static double[] dblFilter(double[] doubles, DoublePredicate predicate) {
        return DblStreamUtils.defaultDblStream(doubles).filter(predicate).toArray();
    }

    public static Set<Double> dblFilterToSet(double[] doubles, DoublePredicate predicate) {
        return DblFilterUtils.dblFilter(doubles, DoubleFilterCollector.of(predicate, Collectors.toSet()));
    }

    public static double[] dblFilterDistinct(double[] doubles, DoublePredicate predicate) {
        return DblStreamUtils.defaultDblStream(doubles).filter(predicate).distinct().toArray();
    }

    public static <C extends Collection<Double>> C dblFilter(double[] doubles, DoubleFilterCollector<C> filterCollector) {
        return (C)((Collection)DblStreamUtils.defaultDblStream(doubles).filter(filterCollector.getFilter()).boxed().collect(filterCollector.getCollector()));
    }

    public static <C extends Collection<Double>> C dblFilterDistinct(double[] doubles, DoubleFilterCollector<C> filterCollector) {
        return (C)((Collection)DblStreamUtils.defaultDblStream(doubles).filter(filterCollector.getFilter()).distinct().boxed().collect(filterCollector.getCollector()));
    }

    public static <C extends Collection<Double>> DoubleFilterCollector<C> dblFilterAndThen(DoublePredicate filter, Collector<Double, ?, C> collector) {
        return DoubleFilterCollector.of(filter, collector);
    }
}

