/*
 * Decompiled with CFR 0.152.
 */
package org.perro.functions.predicate;

import java.util.Collection;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.DoubleFunction;
import java.util.function.DoublePredicate;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToDoubleFunction;
import org.perro.functions.predicate.CollectionUtils;
import org.perro.functions.predicate.DoubleWithDelta;
import org.perro.functions.predicate.PredicateUtils;
import org.perro.functions.stream.DblStreamUtils;
import org.perro.functions.stream.StreamUtils;

public final class DblPredicateUtils {
    private DblPredicateUtils() {
    }

    public static DoublePredicate dblPredicate(DoublePredicate predicate) {
        return predicate;
    }

    public static <U> DoublePredicate dblPredicate(BiPredicate<Double, ? super U> biPredicate, U value) {
        return d -> biPredicate.test(d, (Object)value);
    }

    public static <U> DoublePredicate inverseDblPredicate(BiPredicate<? super U, Double> biPredicate, U value) {
        return d -> biPredicate.test((Object)value, d);
    }

    public static DoublePredicate dblConstant(boolean b) {
        return d -> b;
    }

    public static DoublePredicate dblNot(DoublePredicate predicate) {
        return predicate.negate();
    }

    public static DoublePredicate isDblEqual(double value) {
        return d -> d == value;
    }

    public static DoublePredicate isDblEqual(double value, double delta) {
        return d -> DoubleWithDelta.of(value, delta).isEqualWithinDelta(d);
    }

    public static DoublePredicate isDblEqual(DoubleUnaryOperator operator, double value) {
        return d -> operator.applyAsDouble(d) == value;
    }

    public static DoublePredicate isDblEqual(DoubleUnaryOperator operator, DoubleWithDelta doubleWithDelta) {
        return d -> doubleWithDelta.isEqualWithinDelta(operator.applyAsDouble(d));
    }

    public static DoublePredicate isDblNotEqual(double value) {
        return DblPredicateUtils.dblNot(DblPredicateUtils.isDblEqual(value));
    }

    public static DoublePredicate isDblNotEqual(double value, double delta) {
        return d -> !DoubleWithDelta.of(value, delta).isEqualWithinDelta(d);
    }

    public static DoublePredicate isDblNotEqual(DoubleUnaryOperator operator, double value) {
        return DblPredicateUtils.dblNot(DblPredicateUtils.isDblEqual(operator, value));
    }

    public static DoublePredicate isDblNotEqual(DoubleUnaryOperator operator, DoubleWithDelta doubleWithDelta) {
        return d -> !doubleWithDelta.isEqualWithinDelta(operator.applyAsDouble(d));
    }

    public static <R> DoublePredicate dblToObjContains(Collection<? extends R> collection, DoubleFunction<? extends R> function) {
        return d -> collection != null && collection.contains(function.apply(d));
    }

    public static <R> DoublePredicate inverseDblToObjContains(DoubleFunction<? extends Collection<R>> function, R value) {
        return d -> {
            Collection collection = (Collection)function.apply(d);
            return collection != null && collection.contains(value);
        };
    }

    public static <T> Predicate<T> objToDblContains(double[] doubles, ToDoubleFunction<? super T> function) {
        return t -> doubles != null && DblStreamUtils.dblAnyMatch(doubles, DblPredicateUtils.isDblEqual(function.applyAsDouble(t)));
    }

    public static <T> Predicate<T> inverseObjToDblContains(Function<T, double[]> function, double value) {
        return t -> t != null && DblStreamUtils.dblAnyMatch((double[])function.apply(t), DblPredicateUtils.isDblEqual(value));
    }

    public static DoublePredicate dblIsNull(DoubleFunction<?> function) {
        return d -> Objects.isNull(function.apply(d));
    }

    public static DoublePredicate dblIsNotNull(DoubleFunction<?> function) {
        return DblPredicateUtils.dblNot(DblPredicateUtils.dblIsNull(function));
    }

    public static DoublePredicate dblGt(double compareTo) {
        return d -> d > compareTo;
    }

    public static <R extends Comparable<R>> DoublePredicate dblGt(DoubleFunction<? extends R> function, R compareTo) {
        return d -> Objects.compare(function.apply(d), compareTo, Comparator.nullsLast(Comparator.naturalOrder())) > 0;
    }

    public static <T> Predicate<T> toDblGt(ToDoubleFunction<? super T> function, double compareTo) {
        return t -> t != null && function.applyAsDouble(t) > compareTo;
    }

    public static DoublePredicate dblGte(double compareTo) {
        return d -> d >= compareTo;
    }

    public static <R extends Comparable<R>> DoublePredicate dblGte(DoubleFunction<? extends R> function, R compareTo) {
        return d -> Objects.compare(function.apply(d), compareTo, Comparator.nullsLast(Comparator.naturalOrder())) >= 0;
    }

    public static <T> Predicate<T> toDblGte(ToDoubleFunction<? super T> function, double compareTo) {
        return t -> t != null && function.applyAsDouble(t) >= compareTo;
    }

    public static DoublePredicate dblLt(double compareTo) {
        return d -> d < compareTo;
    }

    public static <R extends Comparable<R>> DoublePredicate dblLt(DoubleFunction<? extends R> function, R compareTo) {
        return d -> Objects.compare(function.apply(d), compareTo, Comparator.nullsLast(Comparator.naturalOrder())) < 0;
    }

    public static <T> Predicate<T> toDblLt(ToDoubleFunction<? super T> function, double compareTo) {
        return t -> t != null && function.applyAsDouble(t) < compareTo;
    }

    public static DoublePredicate dblLte(double compareTo) {
        return d -> d <= compareTo;
    }

    public static <R extends Comparable<R>> DoublePredicate dblLte(DoubleFunction<? extends R> function, R compareTo) {
        return d -> Objects.compare(function.apply(d), compareTo, Comparator.nullsLast(Comparator.naturalOrder())) <= 0;
    }

    public static <T> Predicate<T> toDblLte(ToDoubleFunction<? super T> function, double compareTo) {
        return t -> t != null && function.applyAsDouble(t) <= compareTo;
    }

    public static DoublePredicate isDblCollEmpty(DoubleFunction<? extends Collection<?>> function) {
        return d -> CollectionUtils.isEmpty((Collection)function.apply(d));
    }

    public static DoublePredicate isDblCollNotEmpty(DoubleFunction<? extends Collection<?>> function) {
        return DblPredicateUtils.dblNot(DblPredicateUtils.isDblCollEmpty(function));
    }

    public static <T> Predicate<T> isDblArrayEmpty(Function<? super T, double[]> function) {
        return t -> {
            double[] doubles = t == null ? null : (double[])function.apply(t);
            return doubles == null || doubles.length == 0;
        };
    }

    public static <T> Predicate<T> isDblArrayNotEmpty(Function<? super T, double[]> function) {
        return PredicateUtils.not(DblPredicateUtils.isDblArrayEmpty(function));
    }

    public static <T> Predicate<T> objToDblsAllMatch(Function<T, ? extends double[]> function, DoublePredicate predicate) {
        return t -> t != null && DblStreamUtils.dblAllMatch((double[])function.apply(t), predicate);
    }

    public static <R> DoublePredicate dblToObjsAllMatch(DoubleFunction<? extends Collection<R>> function, Predicate<R> predicate) {
        return d -> StreamUtils.allMatch((Collection)function.apply(d), predicate);
    }

    public static <T> Predicate<T> objToDblsAnyMatch(Function<T, ? extends double[]> function, DoublePredicate predicate) {
        return t -> t != null && DblStreamUtils.dblAnyMatch((double[])function.apply(t), predicate);
    }

    public static <R> DoublePredicate dblToObjsAnyMatch(DoubleFunction<? extends Collection<R>> function, Predicate<R> predicate) {
        return d -> StreamUtils.anyMatch((Collection)function.apply(d), predicate);
    }

    public static <T> Predicate<T> objToDblsNoneMatch(Function<T, ? extends double[]> function, DoublePredicate predicate) {
        return t -> t != null && DblStreamUtils.dblNoneMatch((double[])function.apply(t), predicate);
    }

    public static <R> DoublePredicate dblToObjsNoneMatch(DoubleFunction<? extends Collection<R>> function, Predicate<R> predicate) {
        return d -> StreamUtils.noneMatch((Collection)function.apply(d), predicate);
    }

    public static <T> Predicate<T> mapToDblAndFilter(ToDoubleFunction<? super T> function, DoublePredicate predicate) {
        return t -> predicate.test(function.applyAsDouble(t));
    }

    public static <T> DoublePredicate dblMapAndFilter(DoubleFunction<? extends T> function, Predicate<? super T> predicate) {
        return d -> predicate.test((Object)function.apply(d));
    }

    public static DoubleWithDelta dblWithDelta(double value, double delta) {
        return DoubleWithDelta.of(value, delta);
    }
}

