/*
 * Decompiled with CFR 0.152.
 */
package org.perro.functions.predicate;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.perro.functions.predicate.FilterCollector;
import org.perro.functions.predicate.PredicateUtils;
import org.perro.functions.stream.StreamUtils;

public final class FilterUtils {
    private FilterUtils() {
    }

    public static <T> List<T> filter(Collection<T> objects, Predicate<T> predicate) {
        return FilterUtils.filter(objects, FilterCollector.of(predicate, Collectors.toList()));
    }

    public static <T> Set<T> filterToSet(Collection<T> objects, Predicate<T> predicate) {
        return FilterUtils.filter(objects, FilterCollector.of(predicate, Collectors.toSet()));
    }

    public static <T> List<T> filterDistinct(Collection<T> objects, Predicate<T> predicate) {
        return StreamUtils.defaultStream(objects).filter(PredicateUtils.predicate(predicate)).distinct().collect(Collectors.toList());
    }

    public static <T, C extends Collection<T>> C filter(Collection<T> objects, FilterCollector<T, C> filterCollector) {
        return (C)((Collection)StreamUtils.defaultStream(objects).filter(filterCollector.getFilter()).collect(filterCollector.getCollector()));
    }

    public static <T, C extends Collection<T>> FilterCollector<T, C> filterAndThen(Predicate<T> filter, Collector<T, ?, C> collector) {
        return FilterCollector.of(filter, collector);
    }
}

