/*
 * Decompiled with CFR 0.152.
 */
package org.perro.functions.predicate;

import java.util.Collection;
import java.util.Set;
import java.util.function.IntPredicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.perro.functions.predicate.IntFilterCollector;
import org.perro.functions.stream.IntStreamUtils;

public final class IntFilterUtils {
    private IntFilterUtils() {
    }

    public static int[] intFilter(int[] ints, IntPredicate predicate) {
        return IntStreamUtils.defaultIntStream(ints).filter(predicate).toArray();
    }

    public static Set<Integer> intFilterToSet(int[] ints, IntPredicate predicate) {
        return IntFilterUtils.intFilter(ints, IntFilterCollector.of(predicate, Collectors.toSet()));
    }

    public static int[] intFilterDistinct(int[] ints, IntPredicate predicate) {
        return IntStreamUtils.defaultIntStream(ints).filter(predicate).distinct().toArray();
    }

    public static <C extends Collection<Integer>> C intFilter(int[] ints, IntFilterCollector<C> filterCollector) {
        return (C)((Collection)IntStreamUtils.defaultIntStream(ints).filter(filterCollector.getFilter()).boxed().collect(filterCollector.getCollector()));
    }

    public static <C extends Collection<Integer>> C intFilterDistinct(int[] ints, IntFilterCollector<C> filterCollector) {
        return (C)((Collection)IntStreamUtils.defaultIntStream(ints).filter(filterCollector.getFilter()).distinct().boxed().collect(filterCollector.getCollector()));
    }

    public static <C extends Collection<Integer>> IntFilterCollector<C> intFilterAndThen(IntPredicate filter, Collector<Integer, ?, C> collector) {
        return IntFilterCollector.of(filter, collector);
    }
}

