/*
 * Decompiled with CFR 0.152.
 */
package org.perro.functions.predicate;

import java.util.Collection;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.IntPredicate;
import java.util.function.IntUnaryOperator;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import org.perro.functions.predicate.CollectionUtils;
import org.perro.functions.predicate.PredicateUtils;
import org.perro.functions.stream.IntStreamUtils;
import org.perro.functions.stream.StreamUtils;

public final class IntPredicateUtils {
    private IntPredicateUtils() {
    }

    public static IntPredicate intPredicate(IntPredicate predicate) {
        return predicate;
    }

    public static <U> IntPredicate intPredicate(BiPredicate<Integer, ? super U> biPredicate, U value) {
        return i -> biPredicate.test(i, (Object)value);
    }

    public static <U> IntPredicate inverseIntPredicate(BiPredicate<? super U, Integer> biPredicate, U value) {
        return i -> biPredicate.test((Object)value, i);
    }

    public static IntPredicate intConstant(boolean b) {
        return i -> b;
    }

    public static IntPredicate intNot(IntPredicate predicate) {
        return predicate.negate();
    }

    public static IntPredicate isIntEqual(int value) {
        return i -> i == value;
    }

    public static IntPredicate isIntEqual(IntUnaryOperator operator, int value) {
        return d -> operator.applyAsInt(d) == value;
    }

    public static IntPredicate isIntNotEqual(int value) {
        return IntPredicateUtils.intNot(IntPredicateUtils.isIntEqual(value));
    }

    public static IntPredicate isIntNotEqual(IntUnaryOperator operator, int value) {
        return IntPredicateUtils.intNot(IntPredicateUtils.isIntEqual(operator, value));
    }

    public static <R> IntPredicate intToObjContains(Collection<? extends R> collection, IntFunction<? extends R> function) {
        return i -> collection != null && collection.contains(function.apply(i));
    }

    public static <R> IntPredicate inverseIntToObjContains(IntFunction<? extends Collection<R>> function, R value) {
        return i -> {
            Collection collection = (Collection)function.apply(i);
            return collection != null && collection.contains(value);
        };
    }

    public static <T> Predicate<T> objToIntContains(int[] ints, ToIntFunction<? super T> function) {
        return t -> ints != null && IntStreamUtils.intAnyMatch(ints, IntPredicateUtils.isIntEqual(function.applyAsInt(t)));
    }

    public static <T> Predicate<T> inverseObjToIntContains(Function<T, int[]> function, int value) {
        return t -> {
            int[] ints = (int[])function.apply(t);
            return IntStreamUtils.intAnyMatch(ints, IntPredicateUtils.isIntEqual(value));
        };
    }

    public static IntPredicate intIsNull(IntFunction<?> function) {
        return i -> Objects.isNull(function.apply(i));
    }

    public static IntPredicate intIsNotNull(IntFunction<?> function) {
        return IntPredicateUtils.intNot(IntPredicateUtils.intIsNull(function));
    }

    public static IntPredicate intGt(int compareTo) {
        return i -> i > compareTo;
    }

    public static <R extends Comparable<R>> IntPredicate intGt(IntFunction<? extends R> function, R compareTo) {
        return i -> Objects.compare(function.apply(i), compareTo, Comparator.nullsLast(Comparator.naturalOrder())) > 0;
    }

    public static <T> Predicate<T> toIntGt(ToIntFunction<? super T> function, int compareTo) {
        return t -> t != null && function.applyAsInt(t) > compareTo;
    }

    public static IntPredicate intGte(int compareTo) {
        return i -> i >= compareTo;
    }

    public static <R extends Comparable<R>> IntPredicate intGte(IntFunction<? extends R> function, R compareTo) {
        return i -> Objects.compare(function.apply(i), compareTo, Comparator.nullsLast(Comparator.naturalOrder())) >= 0;
    }

    public static <T> Predicate<T> toIntGte(ToIntFunction<? super T> function, int compareTo) {
        return t -> t != null && function.applyAsInt(t) >= compareTo;
    }

    public static IntPredicate intLt(int compareTo) {
        return i -> i < compareTo;
    }

    public static <R extends Comparable<R>> IntPredicate intLt(IntFunction<? extends R> function, R compareTo) {
        return i -> Objects.compare(function.apply(i), compareTo, Comparator.nullsLast(Comparator.naturalOrder())) < 0;
    }

    public static <T> Predicate<T> toIntLt(ToIntFunction<? super T> function, int compareTo) {
        return t -> t != null && function.applyAsInt(t) < compareTo;
    }

    public static IntPredicate intLte(int compareTo) {
        return i -> i <= compareTo;
    }

    public static <R extends Comparable<R>> IntPredicate intLte(IntFunction<? extends R> function, R compareTo) {
        return i -> Objects.compare(function.apply(i), compareTo, Comparator.nullsLast(Comparator.naturalOrder())) <= 0;
    }

    public static <T> Predicate<T> toIntLte(ToIntFunction<? super T> function, int compareTo) {
        return t -> t != null && function.applyAsInt(t) <= compareTo;
    }

    public static IntPredicate isIntCollEmpty(IntFunction<? extends Collection<?>> function) {
        return i -> CollectionUtils.isEmpty((Collection)function.apply(i));
    }

    public static IntPredicate isIntCollNotEmpty(IntFunction<? extends Collection<?>> function) {
        return IntPredicateUtils.intNot(IntPredicateUtils.isIntCollEmpty(function));
    }

    public static <T> Predicate<T> isIntArrayEmpty(Function<? super T, int[]> function) {
        return t -> {
            int[] ints = t == null ? null : (int[])function.apply(t);
            return ints == null || ints.length == 0;
        };
    }

    public static <T> Predicate<T> isIntArrayNotEmpty(Function<? super T, int[]> function) {
        return PredicateUtils.not(IntPredicateUtils.isIntArrayEmpty(function));
    }

    public static <T> Predicate<T> objToIntsAllMatch(Function<T, ? extends int[]> function, IntPredicate predicate) {
        return t -> t != null && IntStreamUtils.intAllMatch((int[])function.apply(t), predicate);
    }

    public static <R> IntPredicate intToObjectsAllMatch(IntFunction<? extends Collection<R>> function, Predicate<R> predicate) {
        return i -> StreamUtils.allMatch((Collection)function.apply(i), predicate);
    }

    public static <T> Predicate<T> objToIntsAnyMatch(Function<T, ? extends int[]> function, IntPredicate predicate) {
        return t -> t != null && IntStreamUtils.intAnyMatch((int[])function.apply(t), predicate);
    }

    public static <R> IntPredicate intToObjectsAnyMatch(IntFunction<? extends Collection<R>> function, Predicate<R> predicate) {
        return i -> StreamUtils.anyMatch((Collection)function.apply(i), predicate);
    }

    public static <T> Predicate<T> objToIntsNoneMatch(Function<T, ? extends int[]> function, IntPredicate predicate) {
        return t -> t != null && IntStreamUtils.intNoneMatch((int[])function.apply(t), predicate);
    }

    public static <R> IntPredicate intToObjectsNoneMatch(IntFunction<? extends Collection<R>> function, Predicate<R> predicate) {
        return i -> StreamUtils.noneMatch((Collection)function.apply(i), predicate);
    }

    public static <T> Predicate<T> mapToIntAndFilter(ToIntFunction<? super T> function, IntPredicate predicate) {
        return i -> predicate.test(function.applyAsInt(i));
    }

    public static <T> IntPredicate intMapAndFilter(IntFunction<? extends T> function, Predicate<? super T> predicate) {
        return i -> predicate.test((Object)function.apply(i));
    }
}

