/*
 * Decompiled with CFR 0.152.
 */
package org.perro.functions.predicate;

import java.util.Collection;
import java.util.Set;
import java.util.function.LongPredicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.perro.functions.predicate.LongFilterCollector;
import org.perro.functions.stream.LongStreamUtils;

public final class LongFilterUtils {
    private LongFilterUtils() {
    }

    public static long[] longFilter(long[] longs, LongPredicate predicate) {
        return LongStreamUtils.defaultLongStream(longs).filter(predicate).toArray();
    }

    public static Set<Long> longFilterToSet(long[] longs, LongPredicate predicate) {
        return LongFilterUtils.longFilter(longs, LongFilterCollector.of(predicate, Collectors.toSet()));
    }

    public static long[] longFilterDistinct(long[] longs, LongPredicate predicate) {
        return LongStreamUtils.defaultLongStream(longs).filter(predicate).distinct().toArray();
    }

    public static <C extends Collection<Long>> C longFilter(long[] longs, LongFilterCollector<C> filterCollector) {
        return (C)((Collection)LongStreamUtils.defaultLongStream(longs).filter(filterCollector.getFilter()).boxed().collect(filterCollector.getCollector()));
    }

    public static <C extends Collection<Long>> C longFilterDistinct(long[] longs, LongFilterCollector<C> filterCollector) {
        return (C)((Collection)LongStreamUtils.defaultLongStream(longs).filter(filterCollector.getFilter()).distinct().boxed().collect(filterCollector.getCollector()));
    }

    public static <C extends Collection<Long>> LongFilterCollector<C> longFilterAndThen(LongPredicate filter, Collector<Long, ?, C> collector) {
        return LongFilterCollector.of(filter, collector);
    }
}

