/*
 * Decompiled with CFR 0.152.
 */
package org.perro.functions.predicate;

import java.util.Collection;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.LongFunction;
import java.util.function.LongPredicate;
import java.util.function.LongUnaryOperator;
import java.util.function.Predicate;
import java.util.function.ToLongFunction;
import org.perro.functions.predicate.CollectionUtils;
import org.perro.functions.predicate.PredicateUtils;
import org.perro.functions.stream.LongStreamUtils;
import org.perro.functions.stream.StreamUtils;

public final class LongPredicateUtils {
    private LongPredicateUtils() {
    }

    public static LongPredicate longPredicate(LongPredicate predicate) {
        return predicate;
    }

    public static <U> LongPredicate longPredicate(BiPredicate<Long, ? super U> biPredicate, U value) {
        return l -> biPredicate.test(l, (Object)value);
    }

    public static <U> LongPredicate inverseLongPredicate(BiPredicate<? super U, Long> biPredicate, U value) {
        return l -> biPredicate.test((Object)value, l);
    }

    public static LongPredicate longConstant(boolean b) {
        return l -> b;
    }

    public static LongPredicate longNot(LongPredicate predicate) {
        return predicate.negate();
    }

    public static LongPredicate isLongEqual(long value) {
        return l -> l == value;
    }

    public static LongPredicate isLongEqual(LongUnaryOperator operator, long value) {
        return d -> operator.applyAsLong(d) == value;
    }

    public static LongPredicate isLongNotEqual(long value) {
        return LongPredicateUtils.longNot(LongPredicateUtils.isLongEqual(value));
    }

    public static LongPredicate isLongNotEqual(LongUnaryOperator operator, long value) {
        return LongPredicateUtils.longNot(LongPredicateUtils.isLongEqual(operator, value));
    }

    public static <R> LongPredicate longToObjContains(Collection<? extends R> collection, LongFunction<? extends R> function) {
        return l -> collection != null && collection.contains(function.apply(l));
    }

    public static <R> LongPredicate inverseLongToObjContains(LongFunction<? extends Collection<R>> function, R value) {
        return l -> {
            Collection collection = (Collection)function.apply(l);
            return collection != null && collection.contains(value);
        };
    }

    public static <T> Predicate<T> objToLongContains(long[] longs, ToLongFunction<? super T> function) {
        return t -> longs != null && LongStreamUtils.longAnyMatch(longs, LongPredicateUtils.isLongEqual(function.applyAsLong(t)));
    }

    public static <T> Predicate<T> inverseObjToLongContains(Function<T, ? extends long[]> function, long value) {
        return t -> {
            long[] longs = (long[])function.apply(t);
            return LongStreamUtils.longAnyMatch(longs, LongPredicateUtils.isLongEqual(value));
        };
    }

    public static LongPredicate longIsNull(LongFunction<?> function) {
        return l -> Objects.isNull(function.apply(l));
    }

    public static LongPredicate longIsNotNull(LongFunction<?> function) {
        return LongPredicateUtils.longNot(LongPredicateUtils.longIsNull(function));
    }

    public static LongPredicate longGt(long compareTo) {
        return l -> l > compareTo;
    }

    public static <R extends Comparable<R>> LongPredicate longGt(LongFunction<? extends R> function, R compareTo) {
        return l -> Objects.compare(function.apply(l), compareTo, Comparator.nullsLast(Comparator.naturalOrder())) > 0;
    }

    public static <T> Predicate<T> toLongGt(ToLongFunction<? super T> function, long compareTo) {
        return t -> t != null && function.applyAsLong(t) > compareTo;
    }

    public static LongPredicate longGte(long compareTo) {
        return l -> l >= compareTo;
    }

    public static <R extends Comparable<R>> LongPredicate longGte(LongFunction<? extends R> function, R compareTo) {
        return l -> Objects.compare(function.apply(l), compareTo, Comparator.nullsLast(Comparator.naturalOrder())) >= 0;
    }

    public static <T> Predicate<T> toLongGte(ToLongFunction<? super T> function, long compareTo) {
        return t -> t != null && function.applyAsLong(t) >= compareTo;
    }

    public static LongPredicate longLt(long compareTo) {
        return l -> l < compareTo;
    }

    public static <R extends Comparable<R>> LongPredicate longLt(LongFunction<? extends R> function, R compareTo) {
        return l -> Objects.compare(function.apply(l), compareTo, Comparator.nullsLast(Comparator.naturalOrder())) < 0;
    }

    public static <T> Predicate<T> toLongLt(ToLongFunction<? super T> function, long compareTo) {
        return t -> t != null && function.applyAsLong(t) < compareTo;
    }

    public static LongPredicate longLte(long compareTo) {
        return l -> l <= compareTo;
    }

    public static <R extends Comparable<R>> LongPredicate longLte(LongFunction<? extends R> function, R compareTo) {
        return l -> Objects.compare(function.apply(l), compareTo, Comparator.nullsLast(Comparator.naturalOrder())) <= 0;
    }

    public static <T> Predicate<T> toLongLte(ToLongFunction<? super T> function, long compareTo) {
        return t -> t != null && function.applyAsLong(t) <= compareTo;
    }

    public static LongPredicate isLongCollEmpty(LongFunction<? extends Collection<?>> function) {
        return l -> CollectionUtils.isEmpty((Collection)function.apply(l));
    }

    public static LongPredicate isLongCollNotEmpty(LongFunction<? extends Collection<?>> function) {
        return LongPredicateUtils.longNot(LongPredicateUtils.isLongCollEmpty(function));
    }

    public static <T> Predicate<T> isLongArrayEmpty(Function<? super T, long[]> function) {
        return t -> {
            long[] longs = t == null ? null : (long[])function.apply(t);
            return longs == null || longs.length == 0;
        };
    }

    public static <T> Predicate<T> isLongArrayNotEmpty(Function<? super T, long[]> function) {
        return PredicateUtils.not(LongPredicateUtils.isLongArrayEmpty(function));
    }

    public static <T> Predicate<T> objToLongsAllMatch(Function<T, ? extends long[]> function, LongPredicate predicate) {
        return t -> t != null && LongStreamUtils.longAllMatch((long[])function.apply(t), predicate);
    }

    public static <R> LongPredicate longToObjectsAllMatch(LongFunction<? extends Collection<R>> function, Predicate<R> predicate) {
        return l -> StreamUtils.allMatch((Collection)function.apply(l), predicate);
    }

    public static <T> Predicate<T> objToLongsAnyMatch(Function<T, ? extends long[]> function, LongPredicate predicate) {
        return t -> t != null && LongStreamUtils.longAnyMatch((long[])function.apply(t), predicate);
    }

    public static <R> LongPredicate longToObjectsAnyMatch(LongFunction<? extends Collection<R>> function, Predicate<R> predicate) {
        return l -> StreamUtils.anyMatch((Collection)function.apply(l), predicate);
    }

    public static <T> Predicate<T> objToLongsNoneMatch(Function<T, ? extends long[]> function, LongPredicate predicate) {
        return t -> t != null && LongStreamUtils.longNoneMatch((long[])function.apply(t), predicate);
    }

    public static <R> LongPredicate longToObjectsNoneMatch(LongFunction<? extends Collection<R>> function, Predicate<R> predicate) {
        return l -> StreamUtils.noneMatch((Collection)function.apply(l), predicate);
    }

    public static <T> Predicate<T> mapToLongAndFilter(ToLongFunction<? super T> function, LongPredicate predicate) {
        return l -> predicate.test(function.applyAsLong(l));
    }

    public static <T> LongPredicate longMapAndFilter(LongFunction<? extends T> function, Predicate<? super T> predicate) {
        return l -> predicate.test((Object)function.apply(l));
    }
}

