/*
 * Decompiled with CFR 0.152.
 */
package org.perro.functions.predicate;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import org.perro.functions.mapper.MapperUtils;
import org.perro.functions.predicate.CharSequenceUtils;
import org.perro.functions.predicate.CollectionUtils;
import org.perro.functions.stream.StreamUtils;

public final class PredicateUtils {
    private PredicateUtils() {
    }

    public static <T> Predicate<T> predicate(Predicate<T> predicate) {
        return predicate;
    }

    public static <T, U> Predicate<T> predicate(BiPredicate<? super T, ? super U> biPredicate, U value) {
        return t -> biPredicate.test((Object)t, (Object)value);
    }

    public static <T, U> Predicate<T> inversePredicate(BiPredicate<? super U, ? super T> biPredicate, U value) {
        return t -> biPredicate.test((Object)value, (Object)t);
    }

    public static <T> Predicate<T> predicateDefault(Predicate<? super T> predicate, boolean defaultIfNull) {
        return t -> t == null ? defaultIfNull : predicate.test(t);
    }

    public static <T> Predicate<T> constant(boolean b) {
        return t -> b;
    }

    public static <T> Predicate<T> fromMapper(Function<T, Boolean> function) {
        return t -> t != null && (Boolean)function.apply(t) != false;
    }

    public static <T> Predicate<T> not(Predicate<T> predicate) {
        return predicate.negate();
    }

    public static <T> Predicate<T> isSeqEmpty(Function<? super T, ? extends CharSequence> function) {
        return t -> t == null || function.apply(t) == null || ((CharSequence)function.apply(t)).length() == 0;
    }

    public static <T> Predicate<T> isSeqNotEmpty(Function<? super T, ? extends CharSequence> function) {
        return PredicateUtils.not(PredicateUtils.isSeqEmpty(function));
    }

    public static <T> Predicate<T> equalsIgnoreCase(Function<? super T, ? extends CharSequence> function, CharSequence value) {
        return t -> CharSequenceUtils.equalsIgnoreCase(t == null ? null : (CharSequence)function.apply(t), value);
    }

    public static <T> Predicate<T> notEqualsIgnoreCase(Function<? super T, ? extends CharSequence> function, CharSequence value) {
        return PredicateUtils.not(PredicateUtils.equalsIgnoreCase(function, value));
    }

    public static <T, R> Predicate<T> isEqual(Function<? super T, ? extends R> function, R value) {
        return t -> Objects.equals(t == null ? null : function.apply(t), value);
    }

    public static <T, R> Predicate<T> isNotEqual(Function<? super T, ? extends R> function, R value) {
        return PredicateUtils.not(PredicateUtils.isEqual(function, value));
    }

    public static <T, R> Predicate<T> contains(Collection<? extends R> collection, Function<? super T, ? extends R> function) {
        return t -> collection != null && t != null && collection.contains(function.apply(t));
    }

    public static <T, R> Predicate<T> inverseContains(Function<? super T, ? extends Collection<R>> function, R value) {
        return t -> {
            if (t != null) {
                Collection collection = (Collection)function.apply(t);
                return collection != null && collection.contains(value);
            }
            return false;
        };
    }

    public static <T, R> Predicate<T> containsAll(Collection<? extends R> collection, Function<? super T, Collection<? extends R>> function) {
        return t -> collection != null && MapperUtils.mapper(function).apply(t) != null && collection.containsAll((Collection)function.apply(t));
    }

    public static <T, R> Predicate<T> inverseContainsAll(Function<? super T, ? extends Collection<R>> function, Collection<? extends R> collection) {
        return t -> collection != null && MapperUtils.mapper(function).apply(t) != null && ((Collection)function.apply(t)).containsAll(collection);
    }

    public static <T, R> Predicate<T> containsKey(Map<R, ?> map, Function<? super T, ? extends R> function) {
        return t -> map != null && t != null && map.containsKey(function.apply(t));
    }

    public static <T, R> Predicate<T> containsValue(Map<?, R> map, Function<? super T, ? extends R> function) {
        return t -> map != null && t != null && map.containsValue(function.apply(t));
    }

    public static <T> Predicate<T> containsChar(Function<? super T, ? extends CharSequence> function, int searchChar) {
        return t -> t != null && CharSequenceUtils.contains((CharSequence)function.apply(t), searchChar);
    }

    public static <T> Predicate<T> containsCharIgnoreCase(Function<? super T, ? extends CharSequence> function, int searchChar) {
        return t -> t != null && CharSequenceUtils.containsIgnoreCase((CharSequence)function.apply(t), searchChar);
    }

    public static <T> Predicate<T> containsSeq(Function<? super T, ? extends CharSequence> function, CharSequence searchSeq) {
        return t -> t != null && CharSequenceUtils.contains((CharSequence)function.apply(t), searchSeq);
    }

    public static <T> Predicate<T> containsSeqIgnoreCase(Function<? super T, ? extends CharSequence> function, CharSequence searchSeq) {
        return t -> t != null && CharSequenceUtils.containsIgnoreCase((CharSequence)function.apply(t), searchSeq);
    }

    public static <T> Predicate<T> isAlpha(Function<? super T, ? extends CharSequence> function) {
        return t -> CharSequenceUtils.isCharacterMatch((CharSequence)function.apply(t), Character::isLetter);
    }

    public static <T> Predicate<T> isAlphanumeric(Function<? super T, ? extends CharSequence> function) {
        return t -> CharSequenceUtils.isCharacterMatch((CharSequence)function.apply(t), Character::isLetterOrDigit);
    }

    public static <T> Predicate<T> isNumeric(Function<? super T, ? extends CharSequence> function) {
        return t -> CharSequenceUtils.isCharacterMatch((CharSequence)function.apply(t), Character::isDigit);
    }

    public static <T> Predicate<T> startsWith(Function<? super T, ? extends CharSequence> function, CharSequence prefix) {
        return t -> t != null && CharSequenceUtils.startsWith((CharSequence)function.apply(t), prefix);
    }

    public static <T> Predicate<T> startsWithIgnoreCase(Function<? super T, ? extends CharSequence> function, CharSequence prefix) {
        return t -> t != null && CharSequenceUtils.startsWithIgnoreCase((CharSequence)function.apply(t), prefix);
    }

    public static <T> Predicate<T> endsWith(Function<? super T, ? extends CharSequence> function, CharSequence suffix) {
        return t -> t != null && CharSequenceUtils.endsWith((CharSequence)function.apply(t), suffix);
    }

    public static <T> Predicate<T> endsWithIgnoreCase(Function<? super T, ? extends CharSequence> function, CharSequence suffix) {
        return t -> t != null && CharSequenceUtils.endsWithIgnoreCase((CharSequence)function.apply(t), suffix);
    }

    public static <T> Predicate<T> anyCharsMatch(Function<? super T, ? extends CharSequence> function, IntPredicate charPredicate) {
        return t -> {
            CharSequence sequence = Optional.ofNullable(t).map(function).orElse(null);
            return CharSequenceUtils.anyCharacterMatches(sequence, charPredicate);
        };
    }

    public static <T> Predicate<T> allCharsMatch(Function<? super T, ? extends CharSequence> function, IntPredicate charPredicate) {
        return t -> {
            CharSequence sequence = Optional.ofNullable(t).map(function).orElse(null);
            return CharSequenceUtils.isCharacterMatch(sequence, charPredicate);
        };
    }

    public static <T> Predicate<T> noCharsMatch(Function<? super T, ? extends CharSequence> function, IntPredicate charPredicate) {
        return t -> {
            CharSequence sequence = Optional.ofNullable(t).map(function).orElse(null);
            return CharSequenceUtils.noCharactersMatch(sequence, charPredicate);
        };
    }

    public static <T> Predicate<T> isNull(Function<? super T, ?> function) {
        return t -> t == null || Objects.isNull(function.apply(t));
    }

    public static <T> Predicate<T> notNull(Function<T, ?> function) {
        return PredicateUtils.not(PredicateUtils.isNull(function));
    }

    public static <T, R extends Comparable<R>> Predicate<T> gt(Function<? super T, ? extends R> function, R compareTo) {
        return target -> PredicateUtils.getComparisonValueNullsLast(target, function, compareTo) > 0;
    }

    public static <T, R extends Comparable<R>> Predicate<T> gte(Function<? super T, ? extends R> function, R compareTo) {
        return target -> PredicateUtils.getComparisonValueNullsLast(target, function, compareTo) >= 0;
    }

    public static <T, R extends Comparable<R>> Predicate<T> lt(Function<? super T, ? extends R> function, R compareTo) {
        return target -> PredicateUtils.getComparisonValueNullsFirst(target, function, compareTo) < 0;
    }

    public static <T, R extends Comparable<R>> Predicate<T> lte(Function<? super T, ? extends R> function, R compareTo) {
        return target -> PredicateUtils.getComparisonValueNullsFirst(target, function, compareTo) <= 0;
    }

    private static <T, R extends Comparable<R>> int getComparisonValueNullsLast(T target, Function<? super T, ? extends R> valueExtractor, R compareTo) {
        return Objects.compare(PredicateUtils.getValueIfTargetNonNull(valueExtractor, target), compareTo, Comparator.nullsLast(Comparator.naturalOrder()));
    }

    private static <T, R extends Comparable<R>> int getComparisonValueNullsFirst(T target, Function<? super T, ? extends R> valueExtractor, R compareTo) {
        return Objects.compare(PredicateUtils.getValueIfTargetNonNull(valueExtractor, target), compareTo, Comparator.nullsFirst(Comparator.naturalOrder()));
    }

    private static <T, R extends Comparable<R>> R getValueIfTargetNonNull(Function<? super T, ? extends R> valueExtractor, T target) {
        return (R)(target == null ? null : (Comparable)valueExtractor.apply(target));
    }

    public static <T> Predicate<T> isCollEmpty(Function<? super T, ? extends Collection<?>> function) {
        return t -> t == null || CollectionUtils.isEmpty((Collection)function.apply(t));
    }

    public static <T> Predicate<T> isCollNotEmpty(Function<? super T, ? extends Collection<?>> function) {
        return PredicateUtils.not(PredicateUtils.isCollEmpty(function));
    }

    public static <T, R> Predicate<T> allMatch(Function<? super T, ? extends Collection<R>> function, Predicate<R> predicate) {
        return t -> t != null && StreamUtils.allMatch((Collection)function.apply(t), predicate);
    }

    public static <T, R> Predicate<T> anyMatch(Function<? super T, ? extends Collection<R>> function, Predicate<R> predicate) {
        return t -> t != null && StreamUtils.anyMatch((Collection)function.apply(t), predicate);
    }

    public static <T, R> Predicate<T> noneMatch(Function<? super T, ? extends Collection<R>> function, Predicate<R> predicate) {
        return t -> t != null && StreamUtils.noneMatch((Collection)function.apply(t), predicate);
    }

    public static <T> Predicate<T> distinctByKey(Function<? super T, ?> function) {
        HashSet uniqueKeys = new HashSet();
        return t -> uniqueKeys.add(function.apply(t));
    }

    public static <T> Predicate<T> distinctByKeyParallel(Function<? super T, ?> function) {
        Set uniqueKeys = Collections.synchronizedSet(new HashSet());
        return t -> uniqueKeys.add(function.apply(t));
    }

    public static <T, R> Predicate<T> mapAndFilter(Function<? super T, ? extends R> function, Predicate<? super R> predicate) {
        return t -> t != null && predicate.test((Object)function.apply(t));
    }
}

