/*
 * Decompiled with CFR 0.152.
 */
package org.perro.functions.stream;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.DoublePredicate;
import java.util.function.DoubleSupplier;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.Stream;
import org.perro.functions.collector.CollectorUtils;
import org.perro.functions.mapper.DblMapperUtils;
import org.perro.functions.mapper.DoubleIndexPair;
import org.perro.functions.predicate.DblPredicateUtils;
import org.perro.functions.stream.FindDoubleWithDefault;
import org.perro.functions.stream.FindDoubleWithDefaultSupplier;

public final class DblStreamUtils {
    private DblStreamUtils() {
    }

    public static boolean dblAllMatch(double[] doubles, DoublePredicate predicate) {
        return doubles != null && Arrays.stream(doubles).allMatch(predicate);
    }

    public static boolean dblAnyMatch(double[] doubles, DoublePredicate predicate) {
        return doubles != null && Arrays.stream(doubles).anyMatch(predicate);
    }

    public static boolean dblNoneMatch(double[] doubles, DoublePredicate predicate) {
        return doubles != null && Arrays.stream(doubles).noneMatch(predicate);
    }

    public static long dblCount(double[] doubles, DoublePredicate predicate) {
        return DblStreamUtils.defaultDblStream(doubles).filter(predicate).count();
    }

    public static double dblMaxDefault(double[] doubles, FindDoubleWithDefault findWithDefault) {
        return DblStreamUtils.defaultDblStream(doubles).filter(findWithDefault.getPredicate()).max().orElse(findWithDefault.getDefaultValue());
    }

    public static double dblMaxDefault(double[] doubles, FindDoubleWithDefaultSupplier findWithDefaultSupplier) {
        return DblStreamUtils.defaultDblStream(doubles).filter(findWithDefaultSupplier.getPredicate()).max().orElseGet(findWithDefaultSupplier.getDefaultSupplier());
    }

    public static double dblMinDefault(double[] doubles, FindDoubleWithDefault findWithDefault) {
        return DblStreamUtils.defaultDblStream(doubles).filter(findWithDefault.getPredicate()).min().orElse(findWithDefault.getDefaultValue());
    }

    public static double dblMinDefault(double[] doubles, FindDoubleWithDefaultSupplier findWithDefaultSupplier) {
        return DblStreamUtils.defaultDblStream(doubles).filter(findWithDefaultSupplier.getPredicate()).min().orElseGet(findWithDefaultSupplier.getDefaultSupplier());
    }

    public static Double findAnyDblDefaultNull(double[] doubles, DoublePredicate predicate) {
        return DblStreamUtils.defaultDblStream(doubles).filter(predicate).boxed().findAny().orElse(null);
    }

    public static double findAnyDblDefault(double[] doubles, FindDoubleWithDefault findWithDefault) {
        return DblStreamUtils.defaultDblStream(doubles).filter(findWithDefault.getPredicate()).findAny().orElse(findWithDefault.getDefaultValue());
    }

    public static double findAnyDblDefault(double[] doubles, FindDoubleWithDefaultSupplier findWithDefaultSupplier) {
        return DblStreamUtils.defaultDblStream(doubles).filter(findWithDefaultSupplier.getPredicate()).findAny().orElseGet(findWithDefaultSupplier.getDefaultSupplier());
    }

    public static Double findFirstDblDefaultNull(double[] doubles, DoublePredicate predicate) {
        return DblStreamUtils.defaultDblStream(doubles).filter(predicate).boxed().findFirst().orElse(null);
    }

    public static double findFirstDblDefault(double[] doubles, FindDoubleWithDefault findWithDefault) {
        return DblStreamUtils.defaultDblStream(doubles).filter(findWithDefault.getPredicate()).findFirst().orElse(findWithDefault.getDefaultValue());
    }

    public static double findFirstDblDefault(double[] doubles, FindDoubleWithDefaultSupplier findWithDefaultSupplier) {
        return DblStreamUtils.defaultDblStream(doubles).filter(findWithDefaultSupplier.getPredicate()).findFirst().orElseGet(findWithDefaultSupplier.getDefaultSupplier());
    }

    public static FindDoubleWithDefault findDblDefault(DoublePredicate predicate, double defaultValue) {
        return FindDoubleWithDefault.of(predicate, defaultValue);
    }

    public static FindDoubleWithDefaultSupplier findDblDefault(DoublePredicate predicate, DoubleSupplier defaultSupplier) {
        return FindDoubleWithDefaultSupplier.of(predicate, defaultSupplier);
    }

    public static int indexOfFirstDbl(double[] doubles, DoublePredicate predicate) {
        return DblStreamUtils.defaultDblStream(doubles).mapToObj(DblMapperUtils.dblPairWithIndex()).filter(DblPredicateUtils.mapToDblAndFilter(DoubleIndexPair::getDoubleValue, predicate)).mapToInt(DoubleIndexPair::getIndex).findFirst().orElse(-1);
    }

    public static List<double[]> toPartitionedDblList(double[] doubles, int partitionSize) {
        return DblStreamUtils.defaultDblStream(doubles).boxed().collect(CollectorUtils.toPartitionedList(partitionSize, DblStreamUtils::toListOfArrays));
    }

    private static List<double[]> toListOfArrays(List<List<Double>> partitions) {
        return partitions.stream().map(DblStreamUtils::listToArray).collect(Collectors.toList());
    }

    private static double[] listToArray(List<Double> doubles) {
        return doubles.stream().mapToDouble(Double::doubleValue).toArray();
    }

    public static Stream<double[]> toPartitionedDblStream(double[] doubles, int partitionSize) {
        return DblStreamUtils.toPartitionedDblList(doubles, partitionSize).stream();
    }

    public static DoubleStream defaultDblStream(double[] array) {
        return array == null ? DoubleStream.empty() : Arrays.stream(array);
    }

    public static DoubleStream defaultDblStream(DoubleStream stream) {
        return stream == null ? DoubleStream.empty() : stream;
    }

    public static DoubleStream defaultDblStream(Collection<Double> objects) {
        return objects == null ? DoubleStream.empty() : objects.stream().mapToDouble(Double::doubleValue);
    }

    public static DoubleStream defaultDblStream(Stream<Double> stream) {
        return stream == null ? DoubleStream.empty() : stream.mapToDouble(Double::doubleValue);
    }
}

