/*
 * Decompiled with CFR 0.152.
 */
package org.perro.functions.stream;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.IntPredicate;
import java.util.function.IntSupplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.perro.functions.collector.CollectorUtils;
import org.perro.functions.mapper.IntIndexPair;
import org.perro.functions.mapper.IntMapperUtils;
import org.perro.functions.predicate.IntPredicateUtils;
import org.perro.functions.stream.FindIntWithDefault;
import org.perro.functions.stream.FindIntWithDefaultSupplier;

public final class IntStreamUtils {
    private IntStreamUtils() {
    }

    public static boolean intAllMatch(int[] ints, IntPredicate predicate) {
        return ints != null && Arrays.stream(ints).allMatch(predicate);
    }

    public static boolean intAnyMatch(int[] ints, IntPredicate predicate) {
        return ints != null && Arrays.stream(ints).anyMatch(predicate);
    }

    public static boolean intNoneMatch(int[] ints, IntPredicate predicate) {
        return ints != null && Arrays.stream(ints).noneMatch(predicate);
    }

    public static long intCount(int[] ints, IntPredicate predicate) {
        return IntStreamUtils.defaultIntStream(ints).filter(predicate).count();
    }

    public static int intMaxDefault(int[] ints, FindIntWithDefault findWithDefault) {
        return IntStreamUtils.defaultIntStream(ints).filter(findWithDefault.getPredicate()).max().orElse(findWithDefault.getDefaultValue());
    }

    public static int intMaxDefault(int[] ints, FindIntWithDefaultSupplier findWithDefaultSupplier) {
        return IntStreamUtils.defaultIntStream(ints).filter(findWithDefaultSupplier.getPredicate()).max().orElseGet(findWithDefaultSupplier.getDefaultSupplier());
    }

    public static int intMinDefault(int[] ints, FindIntWithDefault findWithDefault) {
        return IntStreamUtils.defaultIntStream(ints).filter(findWithDefault.getPredicate()).min().orElse(findWithDefault.getDefaultValue());
    }

    public static int intMinDefault(int[] ints, FindIntWithDefaultSupplier findWithDefaultSupplier) {
        return IntStreamUtils.defaultIntStream(ints).filter(findWithDefaultSupplier.getPredicate()).min().orElseGet(findWithDefaultSupplier.getDefaultSupplier());
    }

    public static Integer findAnyIntDefaultNull(int[] ints, IntPredicate predicate) {
        return IntStreamUtils.defaultIntStream(ints).filter(predicate).boxed().findAny().orElse(null);
    }

    public static int findAnyIntDefault(int[] ints, FindIntWithDefault findWithDefault) {
        return IntStreamUtils.defaultIntStream(ints).filter(findWithDefault.getPredicate()).findAny().orElse(findWithDefault.getDefaultValue());
    }

    public static int findAnyIntDefault(int[] ints, FindIntWithDefaultSupplier findWithDefaultSupplier) {
        return IntStreamUtils.defaultIntStream(ints).filter(findWithDefaultSupplier.getPredicate()).findAny().orElseGet(findWithDefaultSupplier.getDefaultSupplier());
    }

    public static Integer findFirstIntDefaultNull(int[] ints, IntPredicate predicate) {
        return IntStreamUtils.defaultIntStream(ints).filter(predicate).boxed().findFirst().orElse(null);
    }

    public static int findFirstIntDefault(int[] ints, FindIntWithDefault findWithDefault) {
        return IntStreamUtils.defaultIntStream(ints).filter(findWithDefault.getPredicate()).findFirst().orElse(findWithDefault.getDefaultValue());
    }

    public static int findFirstIntDefault(int[] ints, FindIntWithDefaultSupplier findWithDefaultSupplier) {
        return IntStreamUtils.defaultIntStream(ints).filter(findWithDefaultSupplier.getPredicate()).findFirst().orElseGet(findWithDefaultSupplier.getDefaultSupplier());
    }

    public static FindIntWithDefault findIntDefault(IntPredicate predicate, int defaultValue) {
        return FindIntWithDefault.of(predicate, defaultValue);
    }

    public static FindIntWithDefaultSupplier findIntDefault(IntPredicate predicate, IntSupplier defaultSupplier) {
        return FindIntWithDefaultSupplier.of(predicate, defaultSupplier);
    }

    public static int indexOfFirstInt(int[] ints, IntPredicate predicate) {
        return IntStreamUtils.defaultIntStream(ints).mapToObj(IntMapperUtils.intPairWithIndex()).filter(IntPredicateUtils.mapToIntAndFilter(IntIndexPair::getIntValue, predicate)).mapToInt(IntIndexPair::getIndex).findFirst().orElse(-1);
    }

    public static List<int[]> toPartitionedIntList(int[] ints, int partitionSize) {
        return IntStreamUtils.defaultIntStream(ints).boxed().collect(CollectorUtils.toPartitionedList(partitionSize, IntStreamUtils::toListOfArrays));
    }

    private static List<int[]> toListOfArrays(List<List<Integer>> partitions) {
        return partitions.stream().map(IntStreamUtils::listToArray).collect(Collectors.toList());
    }

    private static int[] listToArray(List<Integer> ints) {
        return ints.stream().mapToInt(Integer::intValue).toArray();
    }

    public static Stream<int[]> toPartitionedIntStream(int[] ints, int partitionSize) {
        return IntStreamUtils.toPartitionedIntList(ints, partitionSize).stream();
    }

    public static IntStream defaultIntStream(int[] array) {
        return array == null ? IntStream.empty() : Arrays.stream(array);
    }

    public static IntStream defaultIntStream(IntStream stream) {
        return stream == null ? IntStream.empty() : stream;
    }

    public static IntStream defaultIntStream(Collection<Integer> objects) {
        return objects == null ? IntStream.empty() : objects.stream().mapToInt(Integer::intValue);
    }

    public static IntStream defaultIntStream(Stream<Integer> stream) {
        return stream == null ? IntStream.empty() : stream.mapToInt(Integer::intValue);
    }
}

