/*
 * Decompiled with CFR 0.152.
 */
package org.perro.functions.stream;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.LongPredicate;
import java.util.function.LongSupplier;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.perro.functions.collector.CollectorUtils;
import org.perro.functions.mapper.LongIndexPair;
import org.perro.functions.mapper.LongMapperUtils;
import org.perro.functions.predicate.LongPredicateUtils;
import org.perro.functions.stream.FindLongWithDefault;
import org.perro.functions.stream.FindLongWithDefaultSupplier;

public final class LongStreamUtils {
    private LongStreamUtils() {
    }

    public static boolean longAllMatch(long[] longs, LongPredicate predicate) {
        return longs != null && Arrays.stream(longs).allMatch(predicate);
    }

    public static boolean longAnyMatch(long[] longs, LongPredicate predicate) {
        return longs != null && Arrays.stream(longs).anyMatch(predicate);
    }

    public static boolean longNoneMatch(long[] longs, LongPredicate predicate) {
        return longs != null && Arrays.stream(longs).noneMatch(predicate);
    }

    public static long longCount(long[] longs, LongPredicate predicate) {
        return LongStreamUtils.defaultLongStream(longs).filter(predicate).count();
    }

    public static long longMaxDefault(long[] longs, FindLongWithDefault findWithDefault) {
        return LongStreamUtils.defaultLongStream(longs).filter(findWithDefault.getPredicate()).max().orElse(findWithDefault.getDefaultValue());
    }

    public static long longMaxDefault(long[] longs, FindLongWithDefaultSupplier findWithDefaultSupplier) {
        return LongStreamUtils.defaultLongStream(longs).filter(findWithDefaultSupplier.getPredicate()).max().orElseGet(findWithDefaultSupplier.getDefaultSupplier());
    }

    public static long longMinDefault(long[] longs, FindLongWithDefault findWithDefault) {
        return LongStreamUtils.defaultLongStream(longs).filter(findWithDefault.getPredicate()).min().orElse(findWithDefault.getDefaultValue());
    }

    public static long longMinDefault(long[] longs, FindLongWithDefaultSupplier findWithDefaultSupplier) {
        return LongStreamUtils.defaultLongStream(longs).filter(findWithDefaultSupplier.getPredicate()).min().orElseGet(findWithDefaultSupplier.getDefaultSupplier());
    }

    public static Long findAnyLongDefaultNull(long[] longs, LongPredicate predicate) {
        return LongStreamUtils.defaultLongStream(longs).filter(predicate).boxed().findAny().orElse(null);
    }

    public static long findAnyLongDefault(long[] longs, FindLongWithDefault findWithDefault) {
        return LongStreamUtils.defaultLongStream(longs).filter(findWithDefault.getPredicate()).findAny().orElse(findWithDefault.getDefaultValue());
    }

    public static long findAnyLongDefault(long[] longs, FindLongWithDefaultSupplier findWithDefaultSupplier) {
        return LongStreamUtils.defaultLongStream(longs).filter(findWithDefaultSupplier.getPredicate()).findAny().orElseGet(findWithDefaultSupplier.getDefaultSupplier());
    }

    public static Long findFirstLongDefaultNull(long[] longs, LongPredicate predicate) {
        return LongStreamUtils.defaultLongStream(longs).filter(predicate).boxed().findFirst().orElse(null);
    }

    public static long findFirstLongDefault(long[] longs, FindLongWithDefault findWithDefault) {
        return LongStreamUtils.defaultLongStream(longs).filter(findWithDefault.getPredicate()).findFirst().orElse(findWithDefault.getDefaultValue());
    }

    public static long findFirstLongDefault(long[] longs, FindLongWithDefaultSupplier findWithDefaultSupplier) {
        return LongStreamUtils.defaultLongStream(longs).filter(findWithDefaultSupplier.getPredicate()).findFirst().orElseGet(findWithDefaultSupplier.getDefaultSupplier());
    }

    public static FindLongWithDefault findLongDefault(LongPredicate predicate, long defaultValue) {
        return FindLongWithDefault.of(predicate, defaultValue);
    }

    public static FindLongWithDefaultSupplier findLongDefaultSupplier(LongPredicate predicate, LongSupplier defaultSupplier) {
        return FindLongWithDefaultSupplier.of(predicate, defaultSupplier);
    }

    public static long indexOfFirstLong(long[] longs, LongPredicate predicate) {
        return LongStreamUtils.defaultLongStream(longs).mapToObj(LongMapperUtils.longPairWithIndex()).filter(LongPredicateUtils.mapToLongAndFilter(LongIndexPair::getLongValue, predicate)).mapToLong(LongIndexPair::getIndex).findFirst().orElse(-1L);
    }

    public static List<long[]> toPartitionedLongList(long[] longs, int partitionSize) {
        return LongStreamUtils.defaultLongStream(longs).boxed().collect(CollectorUtils.toPartitionedList(partitionSize, LongStreamUtils::toListOfArrays));
    }

    private static List<long[]> toListOfArrays(List<List<Long>> partitions) {
        return partitions.stream().map(LongStreamUtils::listToArray).collect(Collectors.toList());
    }

    private static long[] listToArray(List<Long> longs) {
        return longs.stream().mapToLong(Long::longValue).toArray();
    }

    public static Stream<long[]> toPartitionedLongStream(long[] longs, int partitionSize) {
        return LongStreamUtils.toPartitionedLongList(longs, partitionSize).stream();
    }

    public static LongStream defaultLongStream(long[] array) {
        return array == null ? LongStream.empty() : Arrays.stream(array);
    }

    public static LongStream defaultLongStream(LongStream stream) {
        return stream == null ? LongStream.empty() : stream;
    }

    public static LongStream defaultLongStream(Collection<Long> objects) {
        return objects == null ? LongStream.empty() : objects.stream().mapToLong(Long::longValue);
    }

    public static LongStream defaultLongStream(Stream<Long> stream) {
        return stream == null ? LongStream.empty() : stream.mapToLong(Long::longValue);
    }
}

