/*
 * Decompiled with CFR 0.152.
 */
package org.perro.functions.stream;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.perro.functions.collector.CollectorUtils;
import org.perro.functions.mapper.MapperUtils;
import org.perro.functions.mapper.ObjectIndexPair;
import org.perro.functions.predicate.PredicateUtils;
import org.perro.functions.stream.CharSequenceMapperWithCollector;
import org.perro.functions.stream.CharSequenceMapperWithDelimiter;
import org.perro.functions.stream.FindWithDefault;
import org.perro.functions.stream.FindWithDefaultSupplier;

public final class StreamUtils {
    private StreamUtils() {
    }

    public static <T> boolean allMatch(Collection<T> objects, Predicate<T> predicate) {
        return objects != null && objects.stream().allMatch(predicate);
    }

    public static <T> boolean anyMatch(Collection<T> objects, Predicate<T> predicate) {
        return objects != null && objects.stream().anyMatch(predicate);
    }

    public static <T> boolean noneMatch(Collection<T> objects, Predicate<T> predicate) {
        return objects != null && objects.stream().noneMatch(predicate);
    }

    public static <T> long count(Collection<T> objects, Predicate<T> predicate) {
        return StreamUtils.defaultStream(objects).filter(Objects::nonNull).filter(predicate).count();
    }

    public static <T extends Comparable<T>> T maxDefaultNull(Collection<T> objects, Predicate<T> predicate) {
        return StreamUtils.maxDefault(objects, StreamUtils.findWithDefault(predicate));
    }

    public static <T extends Comparable<T>> T maxDefault(Collection<T> objects, FindWithDefault<T> findWithDefault) {
        return (T)StreamUtils.defaultStream(objects).filter(Objects::nonNull).filter(findWithDefault.getPredicate()).max(Comparator.naturalOrder()).orElse((Comparable)findWithDefault.getDefaultValue());
    }

    public static <T extends Comparable<T>> T maxDefault(Collection<T> objects, FindWithDefaultSupplier<T> findWithDefaultSupplier) {
        return (T)StreamUtils.defaultStream(objects).filter(Objects::nonNull).filter(findWithDefaultSupplier.getPredicate()).max(Comparator.naturalOrder()).orElseGet(findWithDefaultSupplier.getDefaultSupplier());
    }

    public static <T extends Comparable<T>> T minDefaultNull(Collection<T> objects, Predicate<T> predicate) {
        return StreamUtils.minDefault(objects, StreamUtils.findWithDefault(predicate));
    }

    public static <T extends Comparable<T>> T minDefault(Collection<T> objects, FindWithDefault<T> findWithDefault) {
        return (T)StreamUtils.defaultStream(objects).filter(Objects::nonNull).filter(findWithDefault.getPredicate()).min(Comparator.naturalOrder()).orElse((Comparable)findWithDefault.getDefaultValue());
    }

    public static <T extends Comparable<T>> T minDefault(Collection<T> objects, FindWithDefaultSupplier<T> findWithDefaultSupplier) {
        return (T)StreamUtils.defaultStream(objects).filter(Objects::nonNull).filter(findWithDefaultSupplier.getPredicate()).min(Comparator.naturalOrder()).orElseGet(findWithDefaultSupplier.getDefaultSupplier());
    }

    public static <T> T findAnyDefaultNull(Collection<T> objects, Predicate<T> predicate) {
        return StreamUtils.findAnyWithDefault(objects, StreamUtils.findWithDefault(predicate));
    }

    public static <T> T findAnyWithDefault(Collection<T> objects, FindWithDefault<T> findWithDefault) {
        return (T)StreamUtils.defaultStream(objects).filter(Objects::nonNull).filter(findWithDefault.getPredicate()).findAny().orElse(findWithDefault.getDefaultValue());
    }

    public static <T> T findAnyWithDefault(Collection<T> objects, FindWithDefaultSupplier<T> findWithDefaultSupplier) {
        return (T)StreamUtils.defaultStream(objects).filter(Objects::nonNull).filter(findWithDefaultSupplier.getPredicate()).findAny().orElseGet(findWithDefaultSupplier.getDefaultSupplier());
    }

    public static <T> T findFirstDefaultNull(Collection<T> objects, Predicate<T> predicate) {
        return StreamUtils.findFirstWithDefault(objects, StreamUtils.findWithDefault(predicate));
    }

    public static <T> T findFirstWithDefault(Collection<T> objects, FindWithDefault<T> findWithDefault) {
        return (T)StreamUtils.defaultStream(objects).filter(Objects::nonNull).filter(findWithDefault.getPredicate()).findFirst().orElse(findWithDefault.getDefaultValue());
    }

    public static <T> T findFirstWithDefault(Collection<T> objects, FindWithDefaultSupplier<T> findWithDefaultSupplier) {
        return (T)StreamUtils.defaultStream(objects).filter(Objects::nonNull).filter(findWithDefaultSupplier.getPredicate()).findFirst().orElseGet(findWithDefaultSupplier.getDefaultSupplier());
    }

    private static <T> FindWithDefault<T> findWithDefault(Predicate<T> predicate) {
        return FindWithDefault.of(predicate, null);
    }

    public static <T> FindWithDefault<T> findWithDefault(Predicate<T> predicate, T defaultValue) {
        return FindWithDefault.of(predicate, defaultValue);
    }

    public static <T> FindWithDefaultSupplier<T> findWithDefault(Predicate<T> predicate, Supplier<T> defaultSupplier) {
        return FindWithDefaultSupplier.of(predicate, defaultSupplier);
    }

    public static <T> int indexOfFirst(Collection<T> objects, Predicate<T> predicate) {
        return StreamUtils.defaultStream(objects).map(MapperUtils.pairWithIndex()).filter(PredicateUtils.mapAndFilter(ObjectIndexPair::getObject, predicate)).mapToInt(ObjectIndexPair::getIndex).findFirst().orElse(-1);
    }

    public static <T> String join(Collection<T> objects, Function<T, CharSequence> mapper) {
        return StreamUtils.join(objects, StreamUtils.mapperWithDelimiter(mapper, ","));
    }

    public static <T> String join(Collection<T> objects, CharSequenceMapperWithDelimiter<T> mapperWithDelimiter) {
        return StreamUtils.join(objects, CharSequenceMapperWithCollector.of(mapperWithDelimiter));
    }

    public static <T> String join(Collection<T> objects, CharSequenceMapperWithCollector<T> mapperWithCollector) {
        return StreamUtils.defaultStream(objects).map(mapperWithCollector.getCharSequenceMapper()).collect(mapperWithCollector.getJoiner());
    }

    public static <T> CharSequenceMapperWithDelimiter<T> mapperWithDelimiter(Function<T, CharSequence> charSequenceMapper, CharSequence delimiter) {
        return CharSequenceMapperWithDelimiter.of(charSequenceMapper, delimiter);
    }

    public static <T> CharSequenceMapperWithCollector<T> mapperWithCollector(Function<T, CharSequence> charSequenceMapper, Collector<CharSequence, ?, String> joiner) {
        return CharSequenceMapperWithCollector.of(charSequenceMapper, joiner);
    }

    public static <T> Set<T> subtract(Set<T> from, Set<T> toSubtract) {
        Stream keyStream = StreamUtils.defaultStream(from);
        Set nonNullToSubtract = toSubtract == null ? Collections.emptySet() : toSubtract;
        return keyStream.filter(PredicateUtils.not(PredicateUtils.contains(nonNullToSubtract, Function.identity()))).collect(Collectors.toSet());
    }

    public static <T> List<List<T>> toPartitionedList(Collection<T> objects, int partitionSize) {
        return StreamUtils.defaultStream(objects).collect(CollectorUtils.toPartitionedList(partitionSize));
    }

    public static <T> Stream<List<T>> toPartitionedStream(Collection<T> objects, int partitionSize) {
        return StreamUtils.defaultStream(objects).collect(CollectorUtils.toPartitionedStream(partitionSize));
    }

    public static <T> Stream<T> fromIterator(Iterator<T> iterator) {
        if (iterator != null) {
            Iterable iterable = () -> iterator;
            return StreamSupport.stream(iterable.spliterator(), false);
        }
        return Stream.empty();
    }

    public static <T> Stream<T> defaultStream(Collection<T> objects) {
        return objects == null ? Stream.empty() : objects.stream();
    }

    public static <T> Stream<T> defaultStream(Stream<T> stream) {
        return stream == null ? Stream.empty() : stream;
    }

    public static <T> Stream<T> defaultStream(T[] array) {
        return array == null ? Stream.empty() : Arrays.stream(array);
    }

    public static <T> Stream<T> defaultStream(T target) {
        return target == null ? Stream.empty() : Stream.of(target);
    }
}

