/*
 * Decompiled with CFR 0.152.
 */
package org.perro.functions.supplier;

import java.util.function.DoubleSupplier;
import java.util.function.ToDoubleBiFunction;
import java.util.function.ToDoubleFunction;
import org.perro.functions.supplier.ConstantValues;
import org.perro.functions.supplier.LazyDoubleSupplier;

public final class DblSupplierUtils {
    private DblSupplierUtils() {
    }

    public static <T> DoubleSupplier dblSupplier(ToDoubleFunction<T> function, T value) {
        return () -> function.applyAsDouble(value);
    }

    public static <T, U> DoubleSupplier dblSupplier(ToDoubleBiFunction<T, U> function, ConstantValues<T, U> constants) {
        return () -> function.applyAsDouble(constants.getLeft(), constants.getRight());
    }

    public static DoubleSupplier lazyDblSupplier(DoubleSupplier supplier) {
        return LazyDoubleSupplier.newLazyDoubleSupplier(supplier);
    }

    public static <T> DoubleSupplier lazyDblSupplier(ToDoubleFunction<T> function, T value) {
        return LazyDoubleSupplier.newLazyDoubleSupplier(DblSupplierUtils.dblSupplier(function, value));
    }

    public static <T, U> DoubleSupplier lazyDblSupplier(ToDoubleBiFunction<T, U> function, ConstantValues<T, U> constants) {
        return LazyDoubleSupplier.newLazyDoubleSupplier(DblSupplierUtils.dblSupplier(function, constants));
    }
}

