/*
 * Decompiled with CFR 0.152.
 */
package org.perro.functions.supplier;

import java.util.function.IntSupplier;
import java.util.function.ToIntBiFunction;
import java.util.function.ToIntFunction;
import org.perro.functions.supplier.ConstantValues;
import org.perro.functions.supplier.LazyIntegerSupplier;

public final class IntSupplierUtils {
    private IntSupplierUtils() {
    }

    public static <T> IntSupplier intSupplier(ToIntFunction<T> function, T value) {
        return () -> function.applyAsInt(value);
    }

    public static <T, U> IntSupplier intSupplier(ToIntBiFunction<T, U> function, ConstantValues<T, U> constants) {
        return () -> function.applyAsInt(constants.getLeft(), constants.getRight());
    }

    public static IntSupplier lazyIntSupplier(IntSupplier supplier) {
        return LazyIntegerSupplier.newLazyIntegerSupplier(supplier);
    }

    public static <T> IntSupplier lazyIntSupplier(ToIntFunction<T> function, T value) {
        return LazyIntegerSupplier.newLazyIntegerSupplier(IntSupplierUtils.intSupplier(function, value));
    }

    public static <T, U> IntSupplier lazyIntSupplier(ToIntBiFunction<T, U> function, ConstantValues<T, U> constants) {
        return LazyIntegerSupplier.newLazyIntegerSupplier(IntSupplierUtils.intSupplier(function, constants));
    }
}

