/*
 * Decompiled with CFR 0.152.
 */
package org.perro.functions.supplier;

import java.util.function.LongSupplier;
import java.util.function.ToLongBiFunction;
import java.util.function.ToLongFunction;
import org.perro.functions.supplier.ConstantValues;
import org.perro.functions.supplier.LazyLongSupplier;

public final class LongSupplierUtils {
    private LongSupplierUtils() {
    }

    public static <T> LongSupplier longSupplier(ToLongFunction<T> function, T value) {
        return () -> function.applyAsLong(value);
    }

    public static <T, U> LongSupplier longSupplier(ToLongBiFunction<T, U> function, ConstantValues<T, U> constants) {
        return () -> function.applyAsLong(constants.getLeft(), constants.getRight());
    }

    public static LongSupplier lazyLongSupplier(LongSupplier supplier) {
        return LazyLongSupplier.newLazyLongSupplier(supplier);
    }

    public static <T> LongSupplier lazyLongSupplier(ToLongFunction<T> function, T value) {
        return LazyLongSupplier.newLazyLongSupplier(LongSupplierUtils.longSupplier(function, value));
    }

    public static <T, U> LongSupplier lazyLongSupplier(ToLongBiFunction<T, U> function, ConstantValues<T, U> constants) {
        return LazyLongSupplier.newLazyLongSupplier(LongSupplierUtils.longSupplier(function, constants));
    }
}

