/*
 * Decompiled with CFR 0.152.
 */
package org.perro.functions.supplier;

import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.perro.functions.supplier.ConstantValues;
import org.perro.functions.supplier.LazySupplier;

public final class SupplierUtils {
    private SupplierUtils() {
    }

    public static <T, R> Supplier<R> supplier(Function<T, R> function, T value) {
        return () -> function.apply(value);
    }

    public static <T, U, R> Supplier<R> supplier(BiFunction<T, U, R> function, ConstantValues<T, U> constants) {
        return () -> function.apply(constants.getLeft(), constants.getRight());
    }

    public static <T> Supplier<T> lazySupplier(Supplier<T> supplier) {
        return LazySupplier.newLazySupplier(supplier);
    }

    public static <T, R> Supplier<R> lazySupplier(Function<T, R> function, T value) {
        return LazySupplier.newLazySupplier(SupplierUtils.supplier(function, value));
    }

    public static <T, U, R> Supplier<R> lazySupplier(BiFunction<T, U, R> function, ConstantValues<T, U> constants) {
        return LazySupplier.newLazySupplier(SupplierUtils.supplier(function, constants));
    }

    public static <T, U> ConstantValues<T, U> constantValues(T left, U right) {
        return ConstantValues.of(left, right);
    }
}

