/*
 * Decompiled with CFR 0.152.
 */
package sop.external.operation;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sop.external.ExternalSOP;
import sop.operation.Version;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\n\u001a\u00020\u00032\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\bH\u0002J\u0016\u0010\u000b\u001a\u00020\u00032\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\bH\u0002J\b\u0010\f\u001a\u00020\u0003H\u0016J\b\u0010\r\u001a\u00020\u0003H\u0016J\b\u0010\u000e\u001a\u00020\u0003H\u0016J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0003H\u0016J\b\u0010\u0013\u001a\u00020\u0003H\u0016J\b\u0010\u0014\u001a\u00020\u0003H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lsop/external/operation/VersionExternal;", "Lsop/operation/Version;", "binary", "", "environment", "Ljava/util/Properties;", "(Ljava/lang/String;Ljava/util/Properties;)V", "commandList", "", "envList", "executeForLine", "executeForLines", "getBackendVersion", "getExtendedVersion", "getName", "getSopSpecImplementationRemarks", "getSopSpecRevisionNumber", "", "getSopSpecVersion", "getSopVVersion", "getVersion", "isSopSpecImplementationIncomplete", "", "external-sop"})
@SourceDebugExtension(value={"SMAP\nVersionExternal.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VersionExternal.kt\nsop/external/operation/VersionExternal\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,103:1\n1#2:104\n37#3,2:105\n37#3,2:107\n*S KotlinDebug\n*F\n+ 1 VersionExternal.kt\nsop/external/operation/VersionExternal\n*L\n82#1:105,2\n94#1:107,2\n*E\n"})
public final class VersionExternal
implements Version {
    @NotNull
    private final List<String> commandList;
    @NotNull
    private final List<String> envList;

    public VersionExternal(@NotNull String binary, @NotNull Properties environment) {
        Intrinsics.checkNotNullParameter((Object)binary, (String)"binary");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Object[] objectArray = new String[]{binary, "version"};
        this.commandList = CollectionsKt.listOf((Object[])objectArray);
        this.envList = ExternalSOP.Companion.propertiesToEnv(environment);
    }

    @NotNull
    public String getName() {
        String string;
        String info = this.executeForLine(this.commandList);
        if (StringsKt.contains$default((CharSequence)info, (CharSequence)" ", (boolean)false, (int)2, null)) {
            String string2 = info.substring(0, StringsKt.lastIndexOf$default((CharSequence)info, (String)" ", (int)0, (boolean)false, (int)6, null));
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        } else {
            string = info;
        }
        return string;
    }

    @NotNull
    public String getVersion() {
        String string;
        String info = this.executeForLine(this.commandList);
        if (StringsKt.contains$default((CharSequence)info, (CharSequence)" ", (boolean)false, (int)2, null)) {
            String string2 = info.substring(StringsKt.lastIndexOf$default((CharSequence)info, (String)" ", (int)0, (boolean)false, (int)6, null) + 1);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
        } else {
            string = info;
        }
        return string;
    }

    @NotNull
    public String getBackendVersion() {
        return this.executeForLines(CollectionsKt.plus((Collection)this.commandList, (Object)"--backend"));
    }

    @NotNull
    public String getExtendedVersion() {
        return this.executeForLines(CollectionsKt.plus((Collection)this.commandList, (Object)"--extended"));
    }

    public int getSopSpecRevisionNumber() {
        String firstLine;
        String string;
        String revision = this.getSopSpecVersion();
        if (StringsKt.contains$default((CharSequence)revision, (CharSequence)"\n", (boolean)false, (int)2, null)) {
            String string2 = revision.substring(0, StringsKt.indexOf$default((CharSequence)revision, (String)"\n", (int)0, (boolean)false, (int)6, null));
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        } else {
            string = firstLine = revision;
        }
        if (!StringsKt.contains$default((CharSequence)firstLine, (CharSequence)"-", (boolean)false, (int)2, null)) {
            return -1;
        }
        String string3 = firstLine.substring(StringsKt.lastIndexOf$default((CharSequence)firstLine, (String)"-", (int)0, (boolean)false, (int)6, null) + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
        return Integer.parseInt(string3);
    }

    public boolean isSopSpecImplementationIncomplete() {
        return StringsKt.startsWith$default((String)this.getSopSpecVersion(), (String)"~", (boolean)false, (int)2, null);
    }

    @Nullable
    public String getSopSpecImplementationRemarks() {
        String revision = this.getSopSpecVersion();
        if (StringsKt.contains$default((CharSequence)revision, (CharSequence)"\n", (boolean)false, (int)2, null)) {
            String string;
            String string2 = revision.substring(StringsKt.indexOf$default((CharSequence)revision, (String)"\n", (int)0, (boolean)false, (int)6, null));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
            String it = string = ((Object)StringsKt.trim((CharSequence)string2)).toString();
            boolean bl = false;
            boolean bl2 = !StringsKt.isBlank((CharSequence)it);
            if (bl2) {
                // empty if block
            }
        }
        return null;
    }

    @NotNull
    public String getSopVVersion() {
        return this.executeForLines(CollectionsKt.plus((Collection)this.commandList, (Object)"--sopv"));
    }

    @NotNull
    public String getSopSpecVersion() {
        return this.executeForLines(CollectionsKt.plus((Collection)this.commandList, (Object)"--sop-spec"));
    }

    private final String executeForLine(List<String> commandList) {
        String string;
        try {
            Collection $this$toTypedArray$iv = commandList;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            $this$toTypedArray$iv = this.envList;
            $i$f$toTypedArray = false;
            thisCollection$iv = $this$toTypedArray$iv;
            Process process = Runtime.getRuntime().exec(thisCollection$iv.toArray(new String[0]), thisCollection$iv.toArray(new String[0]));
            InputStream inputStream = process.getInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"process.inputStream");
            InputStream inputStream2 = inputStream;
            Charset charset = Charsets.UTF_8;
            Reader reader = new InputStreamReader(inputStream2, charset);
            int n = 8192;
            String result = (reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n)).readLine();
            Intrinsics.checkNotNullExpressionValue((Object)process, (String)"process");
            ExternalSOP.Companion.finish(process);
            Intrinsics.checkNotNullExpressionValue((Object)result, (String)"result");
            string = ((Object)StringsKt.trim((CharSequence)result)).toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return string;
    }

    private final String executeForLines(List<String> commandList) {
        String string;
        try {
            Collection $this$toTypedArray$iv = commandList;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            $this$toTypedArray$iv = this.envList;
            $i$f$toTypedArray = false;
            thisCollection$iv = $this$toTypedArray$iv;
            Process process = Runtime.getRuntime().exec(thisCollection$iv.toArray(new String[0]), thisCollection$iv.toArray(new String[0]));
            InputStream inputStream = process.getInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"process.inputStream");
            InputStream inputStream2 = inputStream;
            Charset charset = Charsets.UTF_8;
            Reader reader = new InputStreamReader(inputStream2, charset);
            int n = 8192;
            String result = CollectionsKt.joinToString$default((Iterable)TextStreamsKt.readLines((Reader)(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n))), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
            Intrinsics.checkNotNullExpressionValue((Object)process, (String)"process");
            ExternalSOP.Companion.finish(process);
            string = ((Object)StringsKt.trim((CharSequence)result)).toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return string;
    }
}

