/*
 * Decompiled with CFR 0.152.
 */
package sop.external;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nonnull;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import sop.Ready;
import sop.SOP;
import sop.exception.SOPGPException;
import sop.external.operation.ArmorExternal;
import sop.external.operation.CertifyUserIdExternal;
import sop.external.operation.ChangeKeyPasswordExternal;
import sop.external.operation.DearmorExternal;
import sop.external.operation.DecryptExternal;
import sop.external.operation.DetachedSignExternal;
import sop.external.operation.DetachedVerifyExternal;
import sop.external.operation.EncryptExternal;
import sop.external.operation.ExtractCertExternal;
import sop.external.operation.GenerateKeyExternal;
import sop.external.operation.InlineDetachExternal;
import sop.external.operation.InlineSignExternal;
import sop.external.operation.InlineVerifyExternal;
import sop.external.operation.ListProfilesExternal;
import sop.external.operation.MergeCertsExternal;
import sop.external.operation.RevokeKeyExternal;
import sop.external.operation.UpdateKeyExternal;
import sop.external.operation.ValidateUserIdExternal;
import sop.external.operation.VersionExternal;
import sop.operation.Armor;
import sop.operation.CertifyUserId;
import sop.operation.ChangeKeyPassword;
import sop.operation.Dearmor;
import sop.operation.Decrypt;
import sop.operation.DetachedSign;
import sop.operation.DetachedVerify;
import sop.operation.Encrypt;
import sop.operation.ExtractCert;
import sop.operation.GenerateKey;
import sop.operation.InlineDetach;
import sop.operation.InlineSign;
import sop.operation.InlineVerify;
import sop.operation.ListProfiles;
import sop.operation.MergeCerts;
import sop.operation.RevokeKey;
import sop.operation.UpdateKey;
import sop.operation.ValidateUserId;
import sop.operation.Version;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 02\u00020\u0001:\u000201B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020+H\u0016J\b\u0010,\u001a\u00020-H\u0016J\b\u0010.\u001a\u00020/H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lsop/external/ExternalSOP;", "Lsop/SOP;", "binaryName", "", "properties", "Ljava/util/Properties;", "(Ljava/lang/String;Ljava/util/Properties;)V", "tempDirProvider", "Lsop/external/ExternalSOP$TempDirProvider;", "(Ljava/lang/String;Ljava/util/Properties;Lsop/external/ExternalSOP$TempDirProvider;)V", "armor", "Lsop/operation/Armor;", "certifyUserId", "Lsop/operation/CertifyUserId;", "changeKeyPassword", "Lsop/operation/ChangeKeyPassword;", "dearmor", "Lsop/operation/Dearmor;", "decrypt", "Lsop/operation/Decrypt;", "detachedSign", "Lsop/operation/DetachedSign;", "detachedVerify", "Lsop/operation/DetachedVerify;", "encrypt", "Lsop/operation/Encrypt;", "extractCert", "Lsop/operation/ExtractCert;", "generateKey", "Lsop/operation/GenerateKey;", "inlineDetach", "Lsop/operation/InlineDetach;", "inlineSign", "Lsop/operation/InlineSign;", "inlineVerify", "Lsop/operation/InlineVerify;", "listProfiles", "Lsop/operation/ListProfiles;", "mergeCerts", "Lsop/operation/MergeCerts;", "revokeKey", "Lsop/operation/RevokeKey;", "updateKey", "Lsop/operation/UpdateKey;", "validateUserId", "Lsop/operation/ValidateUserId;", "version", "Lsop/operation/Version;", "Companion", "TempDirProvider", "external-sop"})
public final class ExternalSOP
implements SOP {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String binaryName;
    @NotNull
    private final Properties properties;
    @NotNull
    private final TempDirProvider tempDirProvider;

    public ExternalSOP(@NotNull String binaryName, @NotNull Properties properties, @NotNull TempDirProvider tempDirProvider) {
        Intrinsics.checkNotNullParameter((Object)binaryName, (String)"binaryName");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        Intrinsics.checkNotNullParameter((Object)tempDirProvider, (String)"tempDirProvider");
        this.binaryName = binaryName;
        this.properties = properties;
        this.tempDirProvider = tempDirProvider;
    }

    public /* synthetic */ ExternalSOP(String string, Properties properties, TempDirProvider tempDirProvider, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            properties = new Properties();
        }
        if ((n & 4) != 0) {
            tempDirProvider = Companion.defaultTempDirProvider();
        }
        this(string, properties, tempDirProvider);
    }

    public ExternalSOP(@NotNull String binaryName, @NotNull Properties properties) {
        Intrinsics.checkNotNullParameter((Object)binaryName, (String)"binaryName");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        this(binaryName, properties, Companion.defaultTempDirProvider());
    }

    @NotNull
    public Version version() {
        return new VersionExternal(this.binaryName, this.properties);
    }

    @NotNull
    public GenerateKey generateKey() {
        return new GenerateKeyExternal(this.binaryName, this.properties);
    }

    @NotNull
    public ExtractCert extractCert() {
        return new ExtractCertExternal(this.binaryName, this.properties);
    }

    @NotNull
    public DetachedSign detachedSign() {
        return new DetachedSignExternal(this.binaryName, this.properties, this.tempDirProvider);
    }

    @NotNull
    public InlineSign inlineSign() {
        return new InlineSignExternal(this.binaryName, this.properties);
    }

    @NotNull
    public DetachedVerify detachedVerify() {
        return new DetachedVerifyExternal(this.binaryName, this.properties);
    }

    @NotNull
    public InlineVerify inlineVerify() {
        return new InlineVerifyExternal(this.binaryName, this.properties, this.tempDirProvider);
    }

    @NotNull
    public InlineDetach inlineDetach() {
        return new InlineDetachExternal(this.binaryName, this.properties, this.tempDirProvider);
    }

    @NotNull
    public Encrypt encrypt() {
        return new EncryptExternal(this.binaryName, this.properties, this.tempDirProvider);
    }

    @NotNull
    public Decrypt decrypt() {
        return new DecryptExternal(this.binaryName, this.properties, this.tempDirProvider);
    }

    @NotNull
    public Armor armor() {
        return new ArmorExternal(this.binaryName, this.properties);
    }

    @NotNull
    public Dearmor dearmor() {
        return new DearmorExternal(this.binaryName, this.properties);
    }

    @NotNull
    public ListProfiles listProfiles() {
        return new ListProfilesExternal(this.binaryName, this.properties);
    }

    @NotNull
    public RevokeKey revokeKey() {
        return new RevokeKeyExternal(this.binaryName, this.properties);
    }

    @NotNull
    public ChangeKeyPassword changeKeyPassword() {
        return new ChangeKeyPasswordExternal(this.binaryName, this.properties);
    }

    @NotNull
    public UpdateKey updateKey() {
        return new UpdateKeyExternal(this.binaryName, this.properties);
    }

    @NotNull
    public MergeCerts mergeCerts() {
        return new MergeCertsExternal(this.binaryName, this.properties);
    }

    @NotNull
    public CertifyUserId certifyUserId() {
        return new CertifyUserIdExternal(this.binaryName, this.properties);
    }

    @NotNull
    public ValidateUserId validateUserId() {
        return new ValidateUserIdExternal(this.binaryName, this.properties);
    }

    @JvmStatic
    public static final void finish(@NotNull Process process) throws IOException {
        Companion.finish(process);
    }

    @JvmStatic
    private static final void mapExitCodeOrException(Process process) throws InterruptedException, IOException {
        ExternalSOP.Companion.mapExitCodeOrException(process);
    }

    @JvmStatic
    @NotNull
    public static final List<String> propertiesToEnv(@NotNull Properties properties) {
        return Companion.propertiesToEnv(properties);
    }

    @JvmStatic
    @NotNull
    public static final String readString(@NotNull InputStream inputStream) throws IOException {
        return Companion.readString(inputStream);
    }

    @JvmStatic
    @NotNull
    public static final Ready executeProducingOperation(@NotNull Runtime runtime, @NotNull List<String> commandList, @NotNull List<String> envList) {
        return Companion.executeProducingOperation(runtime, commandList, envList);
    }

    @JvmStatic
    @NotNull
    public static final Ready executeTransformingOperation(@NotNull Runtime runtime, @NotNull List<String> commandList, @NotNull List<String> envList, @NotNull InputStream standardIn) {
        return Companion.executeTransformingOperation(runtime, commandList, envList, standardIn);
    }

    @JvmStatic
    @NotNull
    public static final TempDirProvider defaultTempDirProvider() {
        return Companion.defaultTempDirProvider();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J,\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0007J4\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0003J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J\u0010\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u000fH\u0007\u00a8\u0006\u001a"}, d2={"Lsop/external/ExternalSOP$Companion;", "", "()V", "defaultTempDirProvider", "Lsop/external/ExternalSOP$TempDirProvider;", "executeProducingOperation", "Lsop/Ready;", "runtime", "Ljava/lang/Runtime;", "commandList", "", "", "envList", "executeTransformingOperation", "standardIn", "Ljava/io/InputStream;", "finish", "", "process", "Ljava/lang/Process;", "mapExitCodeOrException", "propertiesToEnv", "properties", "Ljava/util/Properties;", "readString", "inputStream", "external-sop"})
    @SourceDebugExtension(value={"SMAP\nExternalSOP.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExternalSOP.kt\nsop/external/ExternalSOP$Companion\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,345:1\n125#2:346\n152#2,3:347\n1#3:350\n37#4,2:351\n37#4,2:353\n*S KotlinDebug\n*F\n+ 1 ExternalSOP.kt\nsop/external/ExternalSOP$Companion\n*L\n215#1:346\n215#1:347,3\n253#1:351,2\n293#1:353,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void finish(@NotNull Process process) throws IOException {
            Intrinsics.checkNotNullParameter((Object)process, (String)"process");
            try {
                this.mapExitCodeOrException(process);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }

        @JvmStatic
        private final void mapExitCodeOrException(Process process) throws InterruptedException, IOException {
            int exitCode = process.waitFor();
            if (exitCode == 0) {
                return;
            }
            InputStream errIn = process.getErrorStream();
            Intrinsics.checkNotNull((Object)errIn);
            String errorMessage = this.readString(errIn);
            switch (exitCode) {
                case 1: {
                    throw new SOPGPException.UnspecificFailure("External SOP backend reported an unspecific error (" + exitCode + "):\n" + errorMessage);
                }
                case 3: {
                    throw new SOPGPException.NoSignature("External SOP backend reported error NoSignature (" + exitCode + "):\n" + errorMessage);
                }
                case 13: {
                    throw new UnsupportedOperationException("External SOP backend reported error UnsupportedAsymmetricAlgo (" + exitCode + "):\n" + errorMessage);
                }
                case 17: {
                    throw new SOPGPException.CertCannotEncrypt("External SOP backend reported error CertCannotEncrypt (" + exitCode + "):\n" + errorMessage);
                }
                case 19: {
                    throw new SOPGPException.MissingArg("External SOP backend reported error MissingArg (" + exitCode + "):\n" + errorMessage);
                }
                case 23: {
                    throw new SOPGPException.IncompleteVerification("External SOP backend reported error IncompleteVerification (" + exitCode + "):\n" + errorMessage);
                }
                case 29: {
                    throw new SOPGPException.CannotDecrypt("External SOP backend reported error CannotDecrypt (" + exitCode + "):\n" + errorMessage);
                }
                case 31: {
                    throw new SOPGPException.PasswordNotHumanReadable("External SOP backend reported error PasswordNotHumanReadable (" + exitCode + "):\n" + errorMessage);
                }
                case 37: {
                    throw new SOPGPException.UnsupportedOption("External SOP backend reported error UnsupportedOption (" + exitCode + "):\n" + errorMessage);
                }
                case 41: {
                    throw new SOPGPException.BadData("External SOP backend reported error BadData (" + exitCode + "):\n" + errorMessage);
                }
                case 53: {
                    throw new SOPGPException.ExpectedText("External SOP backend reported error ExpectedText (" + exitCode + "):\n" + errorMessage);
                }
                case 59: {
                    throw new SOPGPException.OutputExists("External SOP backend reported error OutputExists (" + exitCode + "):\n" + errorMessage);
                }
                case 61: {
                    throw new SOPGPException.MissingInput("External SOP backend reported error MissingInput (" + exitCode + "):\n" + errorMessage);
                }
                case 67: {
                    throw new SOPGPException.KeyIsProtected("External SOP backend reported error KeyIsProtected (" + exitCode + "):\n" + errorMessage);
                }
                case 69: {
                    throw new SOPGPException.UnsupportedSubcommand("External SOP backend reported error UnsupportedSubcommand (" + exitCode + "):\n" + errorMessage);
                }
                case 71: {
                    throw new SOPGPException.UnsupportedSpecialPrefix("External SOP backend reported error UnsupportedSpecialPrefix (" + exitCode + "):\n" + errorMessage);
                }
                case 73: {
                    throw new SOPGPException.AmbiguousInput("External SOP backend reported error AmbiguousInput (" + exitCode + "):\n" + errorMessage);
                }
                case 79: {
                    throw new SOPGPException.KeyCannotSign("External SOP backend reported error KeyCannotSign (" + exitCode + "):\n" + errorMessage);
                }
                case 83: {
                    throw new SOPGPException.IncompatibleOptions("External SOP backend reported error IncompatibleOptions (" + exitCode + "):\n" + errorMessage);
                }
                case 89: {
                    throw new SOPGPException.UnsupportedProfile("External SOP backend reported error UnsupportedProfile (" + exitCode + "):\n" + errorMessage);
                }
                case 97: {
                    throw new SOPGPException.NoHardwareKeyFound("External SOP backend reported error NoHardwareKeyFound (" + exitCode + "):\n" + errorMessage);
                }
                case 101: {
                    throw new SOPGPException.HardwareKeyFailure("External SOP backend reported error HardwareKeyFailure (" + exitCode + "):\n" + errorMessage);
                }
                case 103: {
                    throw new SOPGPException.PrimaryKeyBad("External SOP backend reported error PrimaryKeyBad (" + exitCode + "):\n" + errorMessage);
                }
                case 107: {
                    throw new SOPGPException.CertUserIdNoMatch("External SOP backend reported error CertUserIdNoMatch (" + exitCode + "):\n" + errorMessage);
                }
                case 109: {
                    throw new SOPGPException.KeyCannotCertify("External SOP backend reported error KeyCannotCertify (" + exitCode + "):\n" + errorMessage);
                }
            }
            throw new RuntimeException("External SOP backend reported unknown exit code (" + exitCode + "):\n" + errorMessage);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final List<String> propertiesToEnv(@NotNull Properties properties) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
            Map $this$map$iv = properties;
            boolean $i$f$map = false;
            Map map = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                void it;
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getKey() + "=" + it.getValue());
            }
            return (List)destination$iv$iv;
        }

        @JvmStatic
        @NotNull
        public final String readString(@NotNull InputStream inputStream) throws IOException {
            Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            byte[] buf = new byte[4096];
            int r = 0;
            while (true) {
                int n;
                int it = n = inputStream.read(buf);
                boolean bl = false;
                r = it;
                if (n <= 0) break;
                bOut.write(buf, 0, r);
            }
            String string = bOut.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        @JvmStatic
        @NotNull
        public final Ready executeProducingOperation(@NotNull Runtime runtime, @NotNull List<String> commandList, @NotNull List<String> envList) {
            Intrinsics.checkNotNullParameter((Object)runtime, (String)"runtime");
            Intrinsics.checkNotNullParameter(commandList, (String)"commandList");
            Intrinsics.checkNotNullParameter(envList, (String)"envList");
            try {
                Collection $this$toTypedArray$iv = commandList;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                $this$toTypedArray$iv = envList;
                $i$f$toTypedArray = false;
                thisCollection$iv = $this$toTypedArray$iv;
                Process process = runtime.exec(thisCollection$iv.toArray(new String[0]), thisCollection$iv.toArray(new String[0]));
                InputStream stdIn = process.getInputStream();
                return new Ready(stdIn, process){
                    final /* synthetic */ InputStream $stdIn;
                    final /* synthetic */ Process $process;
                    {
                        this.$stdIn = $stdIn;
                        this.$process = $process;
                    }

                    public void writeTo(@Nonnull @NotNull OutputStream outputStream) throws IOException {
                        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
                        byte[] buf = new byte[4096];
                        int r = 0;
                        while (true) {
                            int n;
                            int it = n = this.$stdIn.read(buf);
                            boolean bl = false;
                            r = it;
                            if (n < 0) break;
                            outputStream.write(buf, 0, r);
                        }
                        outputStream.flush();
                        outputStream.close();
                        Process process = this.$process;
                        Intrinsics.checkNotNullExpressionValue((Object)process, (String)"$process");
                        ExternalSOP.Companion.finish(process);
                    }
                };
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @JvmStatic
        @NotNull
        public final Ready executeTransformingOperation(@NotNull Runtime runtime, @NotNull List<String> commandList, @NotNull List<String> envList, @NotNull InputStream standardIn) {
            Intrinsics.checkNotNullParameter((Object)runtime, (String)"runtime");
            Intrinsics.checkNotNullParameter(commandList, (String)"commandList");
            Intrinsics.checkNotNullParameter(envList, (String)"envList");
            Intrinsics.checkNotNullParameter((Object)standardIn, (String)"standardIn");
            try {
                Collection $this$toTypedArray$iv = commandList;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                $this$toTypedArray$iv = envList;
                $i$f$toTypedArray = false;
                thisCollection$iv = $this$toTypedArray$iv;
                Process process = runtime.exec(thisCollection$iv.toArray(new String[0]), thisCollection$iv.toArray(new String[0]));
                OutputStream processOut = process.getOutputStream();
                InputStream processIn = process.getInputStream();
                return new Ready(standardIn, processOut, processIn, process){
                    final /* synthetic */ InputStream $standardIn;
                    final /* synthetic */ OutputStream $processOut;
                    final /* synthetic */ InputStream $processIn;
                    final /* synthetic */ Process $process;
                    {
                        this.$standardIn = $standardIn;
                        this.$processOut = $processOut;
                        this.$processIn = $processIn;
                        this.$process = $process;
                    }

                    public void writeTo(@NotNull OutputStream outputStream) {
                        int it;
                        int r;
                        byte[] buf;
                        block4: {
                            Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
                            buf = new byte[4096];
                            r = 0;
                            while (true) {
                                int n;
                                it = n = this.$standardIn.read(buf);
                                boolean bl = false;
                                r = it;
                                if (n <= 0) break;
                                this.$processOut.write(buf, 0, r);
                            }
                            this.$standardIn.close();
                            try {
                                this.$processOut.flush();
                                this.$processOut.close();
                            }
                            catch (IOException e) {
                                if (Intrinsics.areEqual((Object)"Stream closed", (Object)e.getMessage())) break block4;
                                throw e;
                            }
                        }
                        while (true) {
                            int n;
                            it = n = this.$processIn.read(buf);
                            boolean bl = false;
                            r = it;
                            if (n <= 0) break;
                            outputStream.write(buf, 0, r);
                        }
                        this.$processIn.close();
                        outputStream.flush();
                        outputStream.close();
                        Process process = this.$process;
                        Intrinsics.checkNotNullExpressionValue((Object)process, (String)"$process");
                        ExternalSOP.Companion.finish(process);
                    }
                };
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @JvmStatic
        @NotNull
        public final TempDirProvider defaultTempDirProvider() {
            return Companion::defaultTempDirProvider$lambda$2;
        }

        private static final File defaultTempDirProvider$lambda$2() {
            File file = Files.createTempDirectory("ext-sop", new FileAttribute[0]).toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
            return file;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0004\u00c0\u0006\u0003"}, d2={"Lsop/external/ExternalSOP$TempDirProvider;", "", "provideTempDirectory", "Ljava/io/File;", "external-sop"})
    public static interface TempDirProvider {
        @NotNull
        public File provideTempDirectory() throws IOException;
    }
}

