/*
 * Decompiled with CFR 0.152.
 */
package sop.external.operation;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import sop.DecryptionResult;
import sop.ReadyWithResult;
import sop.SessionKey;
import sop.Verification;
import sop.external.ExternalSOP;
import sop.operation.Decrypt;
import sop.util.UTCUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0010\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0018\u001a\u00020\u00012\u0006\u0010\u0019\u001a\u00020\u0013H\u0016J\u0010\u0010\u001a\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u0013H\u0016J\u0010\u0010\u001c\u001a\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u0003H\u0016J\u0010\u0010 \u001a\u00020\u00012\u0006\u0010!\u001a\u00020\"H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lsop/external/operation/DecryptExternal;", "Lsop/operation/Decrypt;", "binary", "", "environment", "Ljava/util/Properties;", "tempDirProvider", "Lsop/external/ExternalSOP$TempDirProvider;", "(Ljava/lang/String;Ljava/util/Properties;Lsop/external/ExternalSOP$TempDirProvider;)V", "argCounter", "", "commandList", "", "envList", "requireVerification", "", "ciphertext", "Lsop/ReadyWithResult;", "Lsop/DecryptionResult;", "Ljava/io/InputStream;", "verifyNotAfter", "timestamp", "Ljava/util/Date;", "verifyNotBefore", "verifyWithCert", "cert", "withKey", "key", "withKeyPassword", "password", "", "withPassword", "withSessionKey", "sessionKey", "Lsop/SessionKey;", "external-sop"})
@SourceDebugExtension(value={"SMAP\nDecryptExternal.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DecryptExternal.kt\nsop/external/operation/DecryptExternal\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,134:1\n37#2,2:135\n*S KotlinDebug\n*F\n+ 1 DecryptExternal.kt\nsop/external/operation/DecryptExternal\n*L\n86#1:135,2\n*E\n"})
public final class DecryptExternal
implements Decrypt {
    @NotNull
    private final ExternalSOP.TempDirProvider tempDirProvider;
    @NotNull
    private final List<String> commandList;
    @NotNull
    private final List<String> envList;
    private int argCounter;
    private boolean requireVerification;

    public DecryptExternal(@NotNull String binary, @NotNull Properties environment, @NotNull ExternalSOP.TempDirProvider tempDirProvider) {
        Intrinsics.checkNotNullParameter((Object)binary, (String)"binary");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)tempDirProvider, (String)"tempDirProvider");
        this.tempDirProvider = tempDirProvider;
        Object[] objectArray = new String[]{binary, "decrypt"};
        this.commandList = CollectionsKt.mutableListOf((Object[])objectArray);
        this.envList = CollectionsKt.toMutableList((Collection)ExternalSOP.Companion.propertiesToEnv(environment));
    }

    @NotNull
    public Decrypt verifyNotBefore(@NotNull Date timestamp) {
        DecryptExternal decryptExternal;
        Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
        DecryptExternal $this$verifyNotBefore_u24lambda_u240 = decryptExternal = this;
        boolean bl = false;
        $this$verifyNotBefore_u24lambda_u240.commandList.add("--verify-not-before=" + UTCUtil.Companion.formatUTCDate(timestamp));
        return decryptExternal;
    }

    @NotNull
    public Decrypt verifyNotAfter(@NotNull Date timestamp) {
        DecryptExternal decryptExternal;
        Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
        DecryptExternal $this$verifyNotAfter_u24lambda_u241 = decryptExternal = this;
        boolean bl = false;
        $this$verifyNotAfter_u24lambda_u241.commandList.add("--verify-not-after=" + UTCUtil.Companion.formatUTCDate(timestamp));
        return decryptExternal;
    }

    @NotNull
    public Decrypt verifyWithCert(@NotNull InputStream cert) {
        DecryptExternal decryptExternal;
        Intrinsics.checkNotNullParameter((Object)cert, (String)"cert");
        DecryptExternal $this$verifyWithCert_u24lambda_u242 = decryptExternal = this;
        boolean bl = false;
        $this$verifyWithCert_u24lambda_u242.commandList.add("--verify-with=@ENV:VERIFY_WITH_" + $this$verifyWithCert_u24lambda_u242.argCounter);
        $this$verifyWithCert_u24lambda_u242.envList.add("VERIFY_WITH_" + $this$verifyWithCert_u24lambda_u242.argCounter + "=" + ExternalSOP.Companion.readString(cert));
        ++$this$verifyWithCert_u24lambda_u242.argCounter;
        $this$verifyWithCert_u24lambda_u242.requireVerification = true;
        return decryptExternal;
    }

    @NotNull
    public Decrypt withSessionKey(@NotNull SessionKey sessionKey) {
        DecryptExternal decryptExternal;
        Intrinsics.checkNotNullParameter((Object)sessionKey, (String)"sessionKey");
        DecryptExternal $this$withSessionKey_u24lambda_u243 = decryptExternal = this;
        boolean bl = false;
        $this$withSessionKey_u24lambda_u243.commandList.add("--with-session-key=@ENV:SESSION_KEY_" + $this$withSessionKey_u24lambda_u243.argCounter);
        $this$withSessionKey_u24lambda_u243.envList.add("SESSION_KEY_" + $this$withSessionKey_u24lambda_u243.argCounter + "=" + sessionKey);
        ++$this$withSessionKey_u24lambda_u243.argCounter;
        return decryptExternal;
    }

    @NotNull
    public Decrypt withPassword(@NotNull String password) {
        DecryptExternal decryptExternal;
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        DecryptExternal $this$withPassword_u24lambda_u244 = decryptExternal = this;
        boolean bl = false;
        $this$withPassword_u24lambda_u244.commandList.add("--with-password=@ENV:PASSWORD_" + $this$withPassword_u24lambda_u244.argCounter);
        $this$withPassword_u24lambda_u244.envList.add("PASSWORD_" + $this$withPassword_u24lambda_u244.argCounter + "=" + password);
        ++$this$withPassword_u24lambda_u244.argCounter;
        return decryptExternal;
    }

    @NotNull
    public Decrypt withKey(@NotNull InputStream key) {
        DecryptExternal decryptExternal;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        DecryptExternal $this$withKey_u24lambda_u245 = decryptExternal = this;
        boolean bl = false;
        $this$withKey_u24lambda_u245.commandList.add("@ENV:KEY_" + $this$withKey_u24lambda_u245.argCounter);
        $this$withKey_u24lambda_u245.envList.add("KEY_" + $this$withKey_u24lambda_u245.argCounter + "=" + ExternalSOP.Companion.readString(key));
        ++$this$withKey_u24lambda_u245.argCounter;
        return decryptExternal;
    }

    @NotNull
    public Decrypt withKeyPassword(@NotNull byte[] password) {
        DecryptExternal decryptExternal;
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        DecryptExternal $this$withKeyPassword_u24lambda_u246 = decryptExternal = this;
        boolean bl = false;
        $this$withKeyPassword_u24lambda_u246.commandList.add("--with-key-password=@ENV:KEY_PASSWORD_" + $this$withKeyPassword_u24lambda_u246.argCounter);
        $this$withKeyPassword_u24lambda_u246.envList.add("KEY_PASSWORD_" + $this$withKeyPassword_u24lambda_u246.argCounter + "=" + new String(password, Charsets.UTF_8));
        ++$this$withKeyPassword_u24lambda_u246.argCounter;
        return decryptExternal;
    }

    @NotNull
    public ReadyWithResult<DecryptionResult> ciphertext(@NotNull InputStream ciphertext2) {
        Intrinsics.checkNotNullParameter((Object)ciphertext2, (String)"ciphertext");
        File tempDir = this.tempDirProvider.provideTempDirectory();
        File sessionKeyOut = new File(tempDir, "session-key-out");
        sessionKeyOut.delete();
        this.commandList.add("--session-key-out=" + sessionKeyOut.getAbsolutePath());
        File verifyOut = new File(tempDir, "verifications-out");
        verifyOut.delete();
        if (this.requireVerification) {
            this.commandList.add("--verifications-out=" + verifyOut.getAbsolutePath());
        }
        try {
            Collection $this$toTypedArray$iv = this.commandList;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            $this$toTypedArray$iv = this.envList;
            $i$f$toTypedArray = false;
            thisCollection$iv = $this$toTypedArray$iv;
            Process process = Runtime.getRuntime().exec(thisCollection$iv.toArray(new String[0]), thisCollection$iv.toArray(new String[0]));
            OutputStream processOut = process.getOutputStream();
            InputStream processIn = process.getInputStream();
            return (ReadyWithResult)new ReadyWithResult<DecryptionResult>(ciphertext2, processOut, processIn, process, sessionKeyOut, this, verifyOut){
                final /* synthetic */ InputStream $ciphertext;
                final /* synthetic */ OutputStream $processOut;
                final /* synthetic */ InputStream $processIn;
                final /* synthetic */ Process $process;
                final /* synthetic */ File $sessionKeyOut;
                final /* synthetic */ DecryptExternal this$0;
                final /* synthetic */ File $verifyOut;
                {
                    this.$ciphertext = $ciphertext;
                    this.$processOut = $processOut;
                    this.$processIn = $processIn;
                    this.$process = $process;
                    this.$sessionKeyOut = $sessionKeyOut;
                    this.this$0 = $receiver;
                    this.$verifyOut = $verifyOut;
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public DecryptionResult writeTo(@NotNull OutputStream outputStream) {
                    SessionKey sessionKey;
                    int it;
                    int n;
                    Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
                    byte[] buf = new byte[4096];
                    int r = 0;
                    while (true) {
                        it = n = this.$ciphertext.read(buf);
                        boolean bl = false;
                        r = it;
                        if (n <= 0) break;
                        this.$processOut.write(buf, 0, r);
                    }
                    this.$ciphertext.close();
                    this.$processOut.close();
                    while (true) {
                        it = n = this.$processIn.read(buf);
                        boolean bl = false;
                        r = it;
                        if (n <= 0) break;
                        outputStream.write(buf, 0, r);
                    }
                    this.$processIn.close();
                    outputStream.close();
                    Process process = this.$process;
                    Intrinsics.checkNotNullExpressionValue((Object)process, (String)"$process");
                    ExternalSOP.Companion.finish(process);
                    FileInputStream sessionKeyOutIn = new FileInputStream(this.$sessionKeyOut);
                    String line = null;
                    String string = line = ExternalSOP.Companion.readString(sessionKeyOutIn);
                    if (string != null) {
                        void $this$trim$iv;
                        String l = string;
                        boolean bl = false;
                        String string2 = l;
                        SessionKey.Companion companion = SessionKey.Companion;
                        boolean $i$f$trim = false;
                        CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
                        boolean $i$f$trim2 = false;
                        int startIndex$iv$iv = 0;
                        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                        boolean startFound$iv$iv = false;
                        while (startIndex$iv$iv <= endIndex$iv$iv) {
                            boolean match$iv$iv;
                            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                            char it2 = $this$trim$iv$iv.charAt(index$iv$iv);
                            boolean bl2 = false;
                            boolean bl3 = match$iv$iv = Intrinsics.compare((int)it2, (int)32) <= 0;
                            if (!startFound$iv$iv) {
                                if (!match$iv$iv) {
                                    startFound$iv$iv = true;
                                    continue;
                                }
                                ++startIndex$iv$iv;
                                continue;
                            }
                            if (!match$iv$iv) break;
                            --endIndex$iv$iv;
                        }
                        sessionKey = companion.fromString(((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString());
                    } else {
                        sessionKey = null;
                    }
                    SessionKey sessionKey2 = sessionKey;
                    sessionKeyOutIn.close();
                    this.$sessionKeyOut.delete();
                    List verifications = new ArrayList<E>();
                    if (DecryptExternal.access$getRequireVerification$p(this.this$0)) {
                        FileInputStream verifyOutIn = new FileInputStream(this.$verifyOut);
                        BufferedReader reader = new BufferedReader(new InputStreamReader(verifyOutIn));
                        while (true) {
                            String it3;
                            String string3;
                            String it4 = string3 = reader.readLine();
                            boolean bl = false;
                            line = it4;
                            if (string3 == null) break;
                            if (line == null) continue;
                            boolean bl4 = false;
                            verifications.add(Verification.Companion.fromString(((Object)StringsKt.trim((CharSequence)it3)).toString()));
                        }
                        reader.close();
                    }
                    return new DecryptionResult(sessionKey2, verifications);
                }
            };
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static final /* synthetic */ boolean access$getRequireVerification$p(DecryptExternal $this) {
        return $this.requireVerification;
    }
}

