/*
 * Decompiled with CFR 0.152.
 */
package sop.external.operation;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import sop.MicAlg;
import sop.ReadyWithResult;
import sop.SigningResult;
import sop.enums.SignAs;
import sop.external.ExternalSOP;
import sop.operation.DetachedSign;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u000e\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J\u0010\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0001H\u0016J\u0010\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lsop/external/operation/DetachedSignExternal;", "Lsop/operation/DetachedSign;", "binary", "", "environment", "Ljava/util/Properties;", "tempDirProvider", "Lsop/external/ExternalSOP$TempDirProvider;", "(Ljava/lang/String;Ljava/util/Properties;Lsop/external/ExternalSOP$TempDirProvider;)V", "argCounter", "", "commandList", "", "envList", "data", "Lsop/ReadyWithResult;", "Lsop/SigningResult;", "Ljava/io/InputStream;", "key", "mode", "Lsop/enums/SignAs;", "noArmor", "withKeyPassword", "password", "", "external-sop"})
@SourceDebugExtension(value={"SMAP\nDetachedSignExternal.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DetachedSignExternal.kt\nsop/external/operation/DetachedSignExternal\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,105:1\n1#2:106\n37#3,2:107\n*S KotlinDebug\n*F\n+ 1 DetachedSignExternal.kt\nsop/external/operation/DetachedSignExternal\n*L\n40#1:107,2\n*E\n"})
public final class DetachedSignExternal
implements DetachedSign {
    @NotNull
    private final ExternalSOP.TempDirProvider tempDirProvider;
    @NotNull
    private final List<String> commandList;
    @NotNull
    private final List<String> envList;
    private int argCounter;

    public DetachedSignExternal(@NotNull String binary, @NotNull Properties environment, @NotNull ExternalSOP.TempDirProvider tempDirProvider) {
        Intrinsics.checkNotNullParameter((Object)binary, (String)"binary");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)tempDirProvider, (String)"tempDirProvider");
        this.tempDirProvider = tempDirProvider;
        Object[] objectArray = new String[]{binary, "sign"};
        this.commandList = CollectionsKt.mutableListOf((Object[])objectArray);
        this.envList = CollectionsKt.toMutableList((Collection)ExternalSOP.Companion.propertiesToEnv(environment));
    }

    @NotNull
    public DetachedSign mode(@NotNull SignAs mode) {
        DetachedSignExternal detachedSignExternal;
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        DetachedSignExternal $this$mode_u24lambda_u240 = detachedSignExternal = this;
        boolean bl = false;
        $this$mode_u24lambda_u240.commandList.add("--as=" + mode);
        return detachedSignExternal;
    }

    @NotNull
    public ReadyWithResult<SigningResult> data(@NotNull InputStream data2) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        File tempDir = this.tempDirProvider.provideTempDirectory();
        File micAlgOut = new File(tempDir, "micAlgOut");
        micAlgOut.delete();
        this.commandList.add("--micalg-out=" + micAlgOut.getAbsolutePath());
        try {
            Collection $this$toTypedArray$iv = this.commandList;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            $this$toTypedArray$iv = this.envList;
            $i$f$toTypedArray = false;
            thisCollection$iv = $this$toTypedArray$iv;
            Process process = Runtime.getRuntime().exec(thisCollection$iv.toArray(new String[0]), thisCollection$iv.toArray(new String[0]));
            OutputStream processOut = process.getOutputStream();
            InputStream processIn = process.getInputStream();
            return (ReadyWithResult)new ReadyWithResult<SigningResult>(data2, processOut, processIn, process, micAlgOut){
                final /* synthetic */ InputStream $data;
                final /* synthetic */ OutputStream $processOut;
                final /* synthetic */ InputStream $processIn;
                final /* synthetic */ Process $process;
                final /* synthetic */ File $micAlgOut;
                {
                    this.$data = $data;
                    this.$processOut = $processOut;
                    this.$processIn = $processIn;
                    this.$process = $process;
                    this.$micAlgOut = $micAlgOut;
                }

                @NotNull
                public SigningResult writeTo(@NotNull OutputStream outputStream) {
                    int it;
                    int r;
                    byte[] buf;
                    block6: {
                        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
                        buf = new byte[4096];
                        r = 0;
                        while (true) {
                            int n;
                            it = n = this.$data.read(buf);
                            boolean bl = false;
                            r = it;
                            if (n <= 0) break;
                            this.$processOut.write(buf, 0, r);
                        }
                        this.$data.close();
                        try {
                            this.$processOut.close();
                        }
                        catch (IOException e) {
                            if (Intrinsics.areEqual((Object)"Stream closed", (Object)e.getMessage())) break block6;
                            throw e;
                        }
                    }
                    while (true) {
                        int e;
                        it = e = this.$processIn.read(buf);
                        boolean bl = false;
                        r = it;
                        if (e <= 0) break;
                        outputStream.write(buf, 0, r);
                    }
                    this.$processIn.close();
                    outputStream.close();
                    Process process = this.$process;
                    Intrinsics.checkNotNullExpressionValue((Object)process, (String)"$process");
                    ExternalSOP.Companion.finish(process);
                    SigningResult.Builder builder = SigningResult.Companion.builder();
                    if (this.$micAlgOut.exists()) {
                        BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(this.$micAlgOut)));
                        String line = reader.readLine();
                        if (line != null && !StringsKt.isBlank((CharSequence)line)) {
                            MicAlg micAlg = new MicAlg(((Object)StringsKt.trim((CharSequence)line)).toString());
                            builder.setMicAlg(micAlg);
                        }
                        reader.close();
                        this.$micAlgOut.delete();
                    }
                    return builder.build();
                }
            };
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public DetachedSign noArmor() {
        DetachedSignExternal detachedSignExternal;
        DetachedSignExternal $this$noArmor_u24lambda_u241 = detachedSignExternal = this;
        boolean bl = false;
        $this$noArmor_u24lambda_u241.commandList.add("--no-armor");
        return detachedSignExternal;
    }

    @NotNull
    public DetachedSign key(@NotNull InputStream key) {
        DetachedSignExternal detachedSignExternal;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        DetachedSignExternal $this$key_u24lambda_u242 = detachedSignExternal = this;
        boolean bl = false;
        $this$key_u24lambda_u242.commandList.add("@ENV:KEY_" + $this$key_u24lambda_u242.argCounter);
        $this$key_u24lambda_u242.envList.add("KEY_" + $this$key_u24lambda_u242.argCounter + "=" + ExternalSOP.Companion.readString(key));
        ++$this$key_u24lambda_u242.argCounter;
        return detachedSignExternal;
    }

    @NotNull
    public DetachedSign withKeyPassword(@NotNull byte[] password) {
        DetachedSignExternal detachedSignExternal;
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        DetachedSignExternal $this$withKeyPassword_u24lambda_u243 = detachedSignExternal = this;
        boolean bl = false;
        $this$withKeyPassword_u24lambda_u243.commandList.add("--with-key-password=@ENV:WITH_KEY_PASSWORD_" + $this$withKeyPassword_u24lambda_u243.argCounter);
        $this$withKeyPassword_u24lambda_u243.envList.add("WITH_KEY_PASSWORD_" + $this$withKeyPassword_u24lambda_u243.argCounter + "=" + new String(password, Charsets.UTF_8));
        ++$this$withKeyPassword_u24lambda_u243.argCounter;
        return detachedSignExternal;
    }
}

