/*
 * Decompiled with CFR 0.152.
 */
package sop.external.operation;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sop.Verification;
import sop.exception.SOPGPException;
import sop.external.ExternalSOP;
import sop.operation.DetachedVerify;
import sop.operation.VerifySignatures;
import sop.util.UTCUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u000bH\u0016J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0011\u001a\u00020\u000bH\u0016J\u0010\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u000f\u001a\u00020\u00182\u0006\u0010\u000f\u001a\u00020\u000bH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lsop/external/operation/DetachedVerifyExternal;", "Lsop/operation/DetachedVerify;", "binary", "", "environment", "Ljava/util/Properties;", "(Ljava/lang/String;Ljava/util/Properties;)V", "argCounter", "", "certs", "", "Ljava/io/InputStream;", "commandList", "", "envList", "signatures", "cert", "data", "", "Lsop/Verification;", "notAfter", "timestamp", "Ljava/util/Date;", "notBefore", "Lsop/operation/VerifySignatures;", "external-sop"})
@SourceDebugExtension(value={"SMAP\nDetachedVerifyExternal.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DetachedVerifyExternal.kt\nsop/external/operation/DetachedVerifyExternal\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,91:1\n1#2:92\n37#3,2:93\n*S KotlinDebug\n*F\n+ 1 DetachedVerifyExternal.kt\nsop/external/operation/DetachedVerifyExternal\n*L\n62#1:93,2\n*E\n"})
public final class DetachedVerifyExternal
implements DetachedVerify {
    @NotNull
    private final List<String> commandList;
    @NotNull
    private final List<String> envList;
    @Nullable
    private InputStream signatures;
    @NotNull
    private final Set<InputStream> certs;
    private int argCounter;

    public DetachedVerifyExternal(@NotNull String binary, @NotNull Properties environment) {
        Intrinsics.checkNotNullParameter((Object)binary, (String)"binary");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Object[] objectArray = new String[]{binary, "verify"};
        this.commandList = CollectionsKt.mutableListOf((Object[])objectArray);
        this.envList = CollectionsKt.toMutableList((Collection)ExternalSOP.Companion.propertiesToEnv(environment));
        this.certs = new LinkedHashSet();
    }

    @NotNull
    public VerifySignatures signatures(@NotNull InputStream signatures) {
        DetachedVerifyExternal detachedVerifyExternal;
        Intrinsics.checkNotNullParameter((Object)signatures, (String)"signatures");
        DetachedVerifyExternal $this$signatures_u24lambda_u240 = detachedVerifyExternal = this;
        boolean bl = false;
        $this$signatures_u24lambda_u240.signatures = signatures;
        return (VerifySignatures)detachedVerifyExternal;
    }

    @NotNull
    public DetachedVerify notBefore(@NotNull Date timestamp) {
        DetachedVerifyExternal detachedVerifyExternal;
        Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
        DetachedVerifyExternal $this$notBefore_u24lambda_u241 = detachedVerifyExternal = this;
        boolean bl = false;
        $this$notBefore_u24lambda_u241.commandList.add("--not-before=" + UTCUtil.Companion.formatUTCDate(timestamp));
        return detachedVerifyExternal;
    }

    @NotNull
    public DetachedVerify notAfter(@NotNull Date timestamp) {
        DetachedVerifyExternal detachedVerifyExternal;
        Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
        DetachedVerifyExternal $this$notAfter_u24lambda_u242 = detachedVerifyExternal = this;
        boolean bl = false;
        $this$notAfter_u24lambda_u242.commandList.add("--not-after=" + UTCUtil.Companion.formatUTCDate(timestamp));
        return detachedVerifyExternal;
    }

    @NotNull
    public DetachedVerify cert(@NotNull InputStream cert) {
        DetachedVerifyExternal detachedVerifyExternal;
        Intrinsics.checkNotNullParameter((Object)cert, (String)"cert");
        DetachedVerifyExternal $this$cert_u24lambda_u243 = detachedVerifyExternal = this;
        boolean bl = false;
        $this$cert_u24lambda_u243.certs.add(cert);
        return detachedVerifyExternal;
    }

    @NotNull
    public List<Verification> data(@NotNull InputStream data2) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        if (this.signatures == null) {
            throw new SOPGPException.MissingArg("Missing argument: signatures cannot be null.");
        }
        this.commandList.add("@ENV:SIGNATURE");
        InputStream inputStream = this.signatures;
        Intrinsics.checkNotNull((Object)inputStream);
        this.envList.add("SIGNATURE=" + ExternalSOP.Companion.readString(inputStream));
        for (InputStream cert : this.certs) {
            this.commandList.add("@ENV:CERT_" + this.argCounter);
            this.envList.add("CERT_" + this.argCounter + "=" + ExternalSOP.Companion.readString(cert));
            ++this.argCounter;
        }
        try {
            Collection $this$toTypedArray$iv = this.commandList;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            $this$toTypedArray$iv = this.envList;
            $i$f$toTypedArray = false;
            thisCollection$iv = $this$toTypedArray$iv;
            Process process = Runtime.getRuntime().exec(thisCollection$iv.toArray(new String[0]), thisCollection$iv.toArray(new String[0]));
            OutputStream processOut = process.getOutputStream();
            InputStream processIn = process.getInputStream();
            byte[] buf = new byte[4096];
            int r = 0;
            while (true) {
                int n;
                int it = n = data2.read(buf);
                boolean bl = false;
                r = it;
                if (n <= 0) break;
                processOut.write(buf, 0, r);
            }
            data2.close();
            processOut.close();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(processIn));
            List verifications = new ArrayList();
            String line = null;
            while (true) {
                String string;
                String it = string = bufferedReader.readLine();
                boolean bl = false;
                line = it;
                if (string == null) break;
                String string2 = line;
                Intrinsics.checkNotNull((Object)string2);
                verifications.add(Verification.Companion.fromString(string2));
            }
            Intrinsics.checkNotNull((Object)process);
            ExternalSOP.Companion.finish(process);
            return verifications;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

