/*
 * Decompiled with CFR 0.152.
 */
package sop.external;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.junit.jupiter.api.Assumptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sop.SOP;
import sop.external.ExternalSOP;

public abstract class AbstractExternalSOPTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractExternalSOPTest.class);
    private final SOP sop;

    public AbstractExternalSOPTest() {
        String backend = AbstractExternalSOPTest.readSopBackendFromProperties();
        Properties environment = AbstractExternalSOPTest.readBackendEnvironment();
        this.sop = new ExternalSOP(backend, environment);
    }

    public SOP getSop() {
        return this.sop;
    }

    public static boolean isExternalSopInstalled() {
        String binary = AbstractExternalSOPTest.readSopBackendFromProperties();
        if (binary == null) {
            return false;
        }
        return new File(binary).exists();
    }

    public void ignoreIf(String name, Is is, String version) {
        String actualName = this.getSop().version().getName();
        String actualVersion = this.getSop().version().getVersion();
        if (!name.matches(actualName)) {
            return;
        }
        ComparableVersion reference = new ComparableVersion(version);
        ComparableVersion actual = new ComparableVersion(actualVersion);
        int res = actual.compareTo(reference);
        String msg = "Skip since installed " + name + " " + actual + " " + is.toDisplay() + " " + reference;
        switch (is) {
            case le: {
                Assumptions.assumeFalse((res < 0 ? 1 : 0) != 0, (String)msg);
                break;
            }
            case leq: {
                Assumptions.assumeFalse((res <= 0 ? 1 : 0) != 0, (String)msg);
            }
            case eq: {
                Assumptions.assumeFalse((res == 0 ? 1 : 0) != 0, (String)msg);
                break;
            }
            case geq: {
                Assumptions.assumeFalse((res >= 0 ? 1 : 0) != 0, (String)msg);
                break;
            }
            case ge: {
                Assumptions.assumeFalse((res > 0 ? 1 : 0) != 0, (String)msg);
            }
        }
    }

    private static String readSopBackendFromProperties() {
        Properties properties = new Properties();
        try {
            InputStream resourceIn = AbstractExternalSOPTest.class.getResourceAsStream("backend.local.properties");
            if (resourceIn == null) {
                LOGGER.info("Could not find backend.local.properties file. Try backend.properties instead.");
                resourceIn = AbstractExternalSOPTest.class.getResourceAsStream("backend.properties");
            }
            if (resourceIn == null) {
                throw new FileNotFoundException("Could not find backend.properties file.");
            }
            properties.load(resourceIn);
            String backend = properties.getProperty("sop.backend");
            return backend;
        }
        catch (IOException e) {
            return null;
        }
    }

    protected static Properties readBackendEnvironment() {
        Properties properties = new Properties();
        try {
            InputStream resourceIn = AbstractExternalSOPTest.class.getResourceAsStream("backend.env");
            if (resourceIn == null) {
                LOGGER.info("Could not read backend.env file.");
            } else {
                properties.load(resourceIn);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return properties;
    }

    public static enum Is {
        le("<"),
        leq("<="),
        eq("=="),
        geq(">="),
        ge(">");

        private final String display;

        private Is(String display) {
            this.display = display;
        }

        public String toDisplay() {
            return this.display;
        }
    }
}

