/*
 * Decompiled with CFR 0.152.
 */
package sop.external;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.EnabledIf;
import sop.ByteArrayAndResult;
import sop.DecryptionResult;
import sop.SessionKey;
import sop.external.AbstractExternalSOPTest;

@EnabledIf(value="sop.external.AbstractExternalSOPTest#isExternalSopInstalled")
public class ExternalDecryptWithSessionKeyTest
extends AbstractExternalSOPTest {
    private static final String CIPHERTEXT = "-----BEGIN PGP MESSAGE-----\n\nwV4DR2b2udXyHrYSAQdAy+Et2hCh4ubh8KsmM8ctRDN6Pee+UHVVcI6YXpY9S2cw\n1QEROCgfm6xGb+hgxmoFrWhtZU03Arb27ZmpWA6e6Ha9jFdB4/DDbqbhlVuFOmti\n0j8BqGjEvEYAon+8F9TwMaDbPjjy9SdgQBorlM88ChIW14KQtpG9FZN+r+xVKPG1\n8EIOxI4qOZaH3Wejraca31M=\n=1imC\n-----END PGP MESSAGE-----\n";
    private static final String SESSION_KEY = "9:ED682800F5FEA829A82E8B7DDF8CE9CF4BF9BB45024B017764462EE53101C36A";

    @Test
    public void testDecryptAndExtractSessionKey() throws IOException {
        ByteArrayAndResult bytesAndResult = this.getSop().decrypt().withKey("-----BEGIN PGP PRIVATE KEY BLOCK-----\nComment: EB85 BB5F A33A 75E1 5E94  4E63 F231 550C 4F47 E38E\nComment: Alice Lovelace <alice@openpgp.example>\n\nxVgEXEcE6RYJKwYBBAHaRw8BAQdArjWwk3FAqyiFbFBKT4TzXcVBqPTB3gmzlC/U\nb7O1u10AAP9XBeW6lzGOLx7zHH9AsUDUTb2pggYGMzd0P3ulJ2AfvQ4RzSZBbGlj\nZSBMb3ZlbGFjZSA8YWxpY2VAb3BlbnBncC5leGFtcGxlPsKQBBMWCAA4AhsDBQsJ\nCAcCBhUKCQgLAgQWAgMBAh4BAheAFiEE64W7X6M6deFelE5j8jFVDE9H444FAl2l\nnzoACgkQ8jFVDE9H447pKwD6A5xwUqIDprBzrHfahrImaYEZzncqb25vkLV2arYf\na78A/R3AwtLQvjxwLDuzk4dUtUwvUYibL2sAHwj2kGaHnfICx10EXEcE6RIKKwYB\nBAGXVQEFAQEHQEL/BiGtq0k84Km1wqQw2DIikVYrQrMttN8d7BPfnr4iAwEIBwAA\n/3/xFPG6U17rhTuq+07gmEvaFYKfxRB6sgAYiW6TMTpQEK7CeAQYFggAIBYhBOuF\nu1+jOnXhXpROY/IxVQxPR+OOBQJcRwTpAhsMAAoJEPIxVQxPR+OOWdABAMUdSzpM\nhzGs1O0RkWNQWbUzQ8nUOeD9wNbjE3zR+yfRAQDbYqvtWQKN4AQLTxVJN5X5AWyb\nPnn+We1aTBhaGa86AQ==\n=3GfK\n-----END PGP PRIVATE KEY BLOCK-----\n".getBytes(StandardCharsets.UTF_8)).ciphertext(CIPHERTEXT.getBytes(StandardCharsets.UTF_8)).toByteArrayAndResult();
        Assertions.assertEquals((Object)SESSION_KEY, (Object)((SessionKey)((DecryptionResult)bytesAndResult.getResult()).getSessionKey().get()).toString());
        Assertions.assertArrayEquals((byte[])"Hello, World!\n".getBytes(StandardCharsets.UTF_8), (byte[])bytesAndResult.getBytes());
    }

    @Test
    public void testDecryptWithSessionKey() throws IOException {
        byte[] decrypted = this.getSop().decrypt().withSessionKey(SessionKey.fromString((String)SESSION_KEY)).ciphertext(CIPHERTEXT.getBytes(StandardCharsets.UTF_8)).toByteArrayAndResult().getBytes();
        Assertions.assertArrayEquals((byte[])"Hello, World!\n".getBytes(StandardCharsets.UTF_8), (byte[])decrypted);
    }
}

