/*
 * Decompiled with CFR 0.152.
 */
package sop.external;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.EnabledIf;
import sop.external.AbstractExternalSOPTest;
import sop.external.JUtils;

@EnabledIf(value="sop.external.AbstractExternalSOPTest#isExternalSopInstalled")
public class ExternalExtractCertTest
extends AbstractExternalSOPTest {
    private static final String BEGIN_PGP_PUBLIC_KEY_BLOCK = "-----BEGIN PGP PUBLIC KEY BLOCK-----\n";
    private static final byte[] BEGIN_PGP_PUBLIC_KEY_BLOCK_BYTES = "-----BEGIN PGP PUBLIC KEY BLOCK-----\n".getBytes(StandardCharsets.UTF_8);

    @Test
    public void extractArmoredCertFromArmoredKeyTest() throws IOException {
        InputStream keyIn = this.getSop().generateKey().userId("Alice <alice@openpgp.org>").generate().getInputStream();
        byte[] cert = this.getSop().extractCert().key(keyIn).getBytes();
        JUtils.assertArrayStartsWith(cert, BEGIN_PGP_PUBLIC_KEY_BLOCK_BYTES);
    }

    @Test
    public void extractUnarmoredCertFromArmoredKeyTest() throws IOException {
        InputStream keyIn = this.getSop().generateKey().userId("Alice <alice@openpgp.org>").generate().getInputStream();
        byte[] cert = this.getSop().extractCert().noArmor().key(keyIn).getBytes();
        Assertions.assertFalse((boolean)JUtils.arrayStartsWith(cert, BEGIN_PGP_PUBLIC_KEY_BLOCK_BYTES));
    }

    @Test
    public void extractArmoredCertFromUnarmoredKeyTest() throws IOException {
        InputStream keyIn = this.getSop().generateKey().userId("Alice <alice@openpgp.org>").noArmor().generate().getInputStream();
        byte[] cert = this.getSop().extractCert().key(keyIn).getBytes();
        JUtils.assertArrayStartsWith(cert, BEGIN_PGP_PUBLIC_KEY_BLOCK_BYTES);
    }

    @Test
    public void extractUnarmoredCertFromUnarmoredKeyTest() throws IOException {
        InputStream keyIn = this.getSop().generateKey().noArmor().userId("Alice <alice@openpgp.org>").generate().getInputStream();
        byte[] cert = this.getSop().extractCert().noArmor().key(keyIn).getBytes();
        Assertions.assertFalse((boolean)JUtils.arrayStartsWith(cert, BEGIN_PGP_PUBLIC_KEY_BLOCK_BYTES));
    }
}

